#include "CS_TrapCage.h"
#include "CS_PeSmoke.h"

CS_TrapCage::CS_TrapCage()
{
	ani.sprite_index = L"ls_trapcage";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 24;
	cbRect.top = 24;
	cbRect.bottom = 8;
	hp_max = hp = 60;
}

void CS_TrapCage::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_TrapCage::Step()
{
	if (trapState)
	{
		//Ƿ񾭹·
		if (gameFunc->GetGlobalEntityTable)
		{
			auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto & p : allPlayer)
			{
				auto wplayer = p.second.lock();
				if (wplayer)
				{
					if (wplayer->el.name == L"null")
						continue;
					if (wplayer->hide)
						continue;
					if (gameFunc->LineTest(shared_from_this(), x / 16, y / 16, wplayer->x / 16, wplayer->y / 16))
						continue;
					if (wplayer->y > y && 
						abs(wplayer->x - x) <= 24)
					{
						trapState = false;
						ani.png = L"CS_CaveStoryMod";
						//
						SetSmoke();
						break;
					}

				}
			}
		}
		return;
	}
	stateGravity.Step();
	stateSplash.Step();
	auto wtarget = target.lock();
	if (wtarget)
	{
		wtarget->attackState = false;
		wtarget->attackState_reset_counter_max = -1;
		wtarget->damage_reset_counter = -1;
		wtarget->drawBeforeOtherEntity = true;
		if (wtarget->inUsing == false)
		{
			target.reset();
			SetSmoke();
			Destroy();
			return;
		}
		wtarget->vx = 0;
		wtarget->vy = 0;
		wtarget->x = x;
		wtarget->last_x = last_x;
		if (wtarget->y < y)
		{
			wtarget->y = y;
			wtarget->last_y = last_y;
		}	
	}
	else if(!cbRect.cbBottom)
	{
		GridTouch();
		if (!touchList.empty())
		{
			//
			for (auto& e : touchList)
			{
				auto we = e.lock();
				if (we)
				{
					if (we->ignoreCaught)
						continue;
					if (we->ignoreCaught_counter > 0)
						continue;
					if (we->hp > 0)
					{
						Catch(we);
						break;
					}
				}
			}
		}
	}
	if (cbRect.cbBottom)
	{
		cbRect.enableSelfSoild = true;
		cbRect.enableMovePlatform = true;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_TrapCage::Destroy()
{
	cbRect.enableSelfSoild = false;
	cbRect.enableMovePlatform = false;
	auto wtarget = target.lock();
	if (wtarget)
	{
		//ָ״̬
		wtarget->attackState = target_attackState;
		wtarget->damage_reset_counter = target_damage_reset_counter;
		wtarget->attackState_reset_counter_max = target_attackState_reset_counter_max;
		wtarget->drawBeforeOtherEntity = target_drawBeforeOtherEntity;
		wtarget->cbRect.ignoreMovePlatform = target_ignoreMovePlatform;
		wtarget->ignoreCaught_counter = 0;
		wtarget->EndCaught(shared_from_this());
	}
	Entity::Destroy();
}

bool CS_TrapCage::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (trapState)
		return false;
	if (getDamage == 0)
		return false;
	if (!cbRect.cbBottom)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_TrapCage::Catch(std::weak_ptr<Entity> target)
{
	this->target = target;
	auto wtarget = target.lock();
	if (wtarget)
	{
		wtarget->x = x;
		if (wtarget->y < y)
			wtarget->y = y;
		wtarget->vx = 0;
		wtarget->vy = 0;
		//沢رղ׽Ĺ״̬
		target_attackState = wtarget->attackState;
		target_damage_reset_counter = wtarget->damage_reset_counter;
		target_attackState_reset_counter_max = wtarget->attackState_reset_counter_max;
		target_drawBeforeOtherEntity = wtarget->drawBeforeOtherEntity;
		target_ignoreMovePlatform = wtarget->cbRect.ignoreMovePlatform;
		wtarget->attackState = false;
		wtarget->attackState_reset_counter_max = -1;
		wtarget->damage_reset_counter = -1;
		wtarget->drawBeforeOtherEntity = true;
		wtarget->ignoreCaught_counter = INT_MAX;
		wtarget->cbRect.ignoreMovePlatform = true;
		gameFunc->PlaySound(L"CS_110");
	}
	//ò׽ͱը
	//ִײ
	Collision();
	//һײ
	Entity::ClearCollisionResult();
}

void CS_TrapCage::SetSmoke()
{
	for (int i = 0; i < 4; i++)
	{
		auto pe = std::make_shared<CS_PeSmoke>();
		pe->x = x + Random(-12, 12);
		pe->y = y + Random(-12, 12);
		pe->vx = Random(-341, 341) / ts;
		pe->vy = Random(-0x600, 0) / ts;
		gameFunc->SetEntity(shared_from_this(), pe);
	}
}

std::shared_ptr<Entity> CreateCS_TrapCage()
{
	return std::make_shared<CS_TrapCage>();
}
