#include "CS_Torch_Mechanism.h"
#include "CS_PeSmoke.h"

CS_Torch_Mechanism::CS_Torch_Mechanism()
{
	ani.png = L"CS_CaveStoryMod";
	drawBeforeOtherEntity = true;
}

void CS_Torch_Mechanism::Init(std::weak_ptr<Entity> self)
{
	auto wtorch = std::make_shared<CS_Torch>();
	torch = wtorch;
	gameFunc->SetEntity(shared_from_this(), wtorch);

	//ù
	auto wpeLight = std::make_shared<CS_PeLightFade>();
	peLight = wpeLight;
	gameFunc->SetEntity(shared_from_this(), wpeLight);

	auto wpeLightColor = std::make_shared<CS_PeLightFade>();
	peLightColor = wpeLightColor;
	wpeLightColor->light.usingLight = false;
	wpeLightColor->color = RGBA(0xff, 0x98, 0, 0x10);
	gameFunc->SetEntity(shared_from_this(), wpeLightColor);

	wpeLight->SetRadius(5);
	wpeLightColor->SetRadius(5);
	wtorch->last_x = wtorch->x = x;
	wtorch->last_y = wtorch->y = y + 16;
	wpeLight->last_x = wpeLight->x = x;
	wpeLight->last_y = wpeLight->y = y;
	wpeLightColor->last_x = wpeLightColor->x = x;
	wpeLightColor->last_y = wpeLightColor->y = y;
	Entity::Init(self);
}

void CS_Torch_Mechanism::Step()
{
	if (lr == 0)
	{
		if (dispear_counter > 0)
			dispear_counter--;
	}
	auto wpeLight = peLight.lock();
	auto wpeLightColor = peLightColor.lock();
	if (dispear_counter == 0 && lr == 0)
	{
		ani.sprite_index = L"";
		if (wpeLight)
			wpeLight->hide = true;
		if (wpeLightColor)
			wpeLightColor->hide = true;
	}
	else
	{
		ani.sprite_index = L"ls_fireplace";
		if (wpeLight)
			wpeLight->hide = false;
		if (wpeLightColor)
			wpeLightColor->hide = false;
	}
	//ִ˶
	Entity::Step();
	auto wtorch = torch.lock();
	if (wtorch)
	{
		wtorch->x = x;
		wtorch->last_x = last_x;
		wtorch->y = y + 16;
		wtorch->last_y = last_y + 16;
	}
	if (wpeLight)
	{
		wpeLight->x = x;
		wpeLight->last_x = last_x;
		wpeLight->y = y;
		wpeLight->last_y = last_y;
	}
	if (wpeLightColor)
	{
		wpeLightColor->x = x;
		wpeLightColor->last_x = last_x;
		wpeLightColor->y = y;
		wpeLightColor->last_y = last_y;
	}
}

void CS_Torch_Mechanism::SetState(std::wstring stateName, int lr)
{

}

bool CS_Torch_Mechanism::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (lr != 0)
		return false;
	if (getDamage == 0)
		return false;
	if (dispear_counter > 0)
		return false;
	dispear_counter = dispear_counter_max;
	*outRealDamage = getDamage;
	gameFunc->PlaySound(L"CS_070_expl_small");
	//
	SetCS_PeSmokeSmall(shared_from_this(), x, y);
	return true;
}

void CS_Torch_Mechanism::Destroy()
{
	auto wtorch = torch.lock();
	if (wtorch)
	{
		wtorch->Destroy();
		torch.reset();
	}
	Entity::Destroy();
}

std::shared_ptr<Entity> CreateCS_Torch_Mechanism()
{
	return std::make_shared<CS_Torch_Mechanism>();
}
