#include "CS_TapAni.h"

CS_TapAni::CS_TapAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
	//
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
}

void CS_TapAni::Init(std::weak_ptr<Entity> self)
{
	Entity::Init(self);
}

void CS_TapAni::Step()
{
}

void CS_TapAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	switch (stateID) 
	{
	case 0:
		ani.sprite_index = L"mc_tap_stand";
		if (bArgInit)
		{
			bArgInit = false;
			if (el.arg.length())
				SetState(el.arg, lr);
		}
		break;
	case 1://
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
		return;
	case 2://
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.erase(3);
		return;
	case 3://ҿ
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.erase(2);
		ani.hideLayerList.insert(3);
		return;
	case 4://¿
		ani.hideLayerList.insert(0);
		ani.hideLayerList.erase(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
		return;
	case 5://
		ani.hideLayerList.erase(0);
		ani.hideLayerList.insert(1);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
		return;
	case 6://
		ani.sprite_index = L"mc_tap_defeated";
		break;
	}
	this->stateID = stateID;
}

void CS_TapAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal_look")
		SetState(1, 0);
	else if (stateName == L"left_look")
		SetState(2, 0);
	else if (stateName == L"right_look")
		SetState(3, 0);
	else if (stateName == L"down_look")
		SetState(4, 0);
	else if (stateName == L"dead_fish_eyes")
		SetState(5, 0);
	else if (stateName == L"defeated")
		SetState(6, 0);
}

std::shared_ptr<Entity> CreateCS_TapAni()
{
	return std::make_shared<CS_TapAni>();
}
