#include "CS_QuoteResist.h"
#include "CS_Quote.h"
#include "EntityStateResist.h"
const int& CS_QuoteSTATENAME_RESIST = ES_STATENAME_RESIST;
CS_QuoteResist::CS_QuoteResist()
{
	SetPhysice(false);
	resist = resist_default;
	enable = true;
	stateID = CS_QuoteSTATENAME_RESIST;
}

void CS_QuoteResist::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	resist = resist_default;
	if (mychar->fishState)
	{
		//
		if (we->vx < 0)
			if (we->vx > -resist)
				we->vx = 0;
			else
				we->vx += resist;
		if (we->vx > 0)
			if (we->vx < resist)
				we->vx = 0;
			else
				we->vx -= resist;
	}
	else
	{
		//
		if (we->cbRect.cbBottom && !PxaIsIce(we->cbRect.pxaBottom) && !(we->cbRect.cbLeft || we->cbRect.cbRight))
		{
			if (we->vx < 0)
				if (we->vx > -resist)
					we->vx = 0;
				else
					we->vx += resist;
			if (we->vx > 0)
				if (we->vx < resist)
					we->vx = 0;
				else
					we->vx -= resist;
		}
	}
}

void CS_QuoteResist::SetPhysice(bool bInWater)
{
	if (bInWater)
		resist_default = inwater_resist_default;
	else
		resist_default = ground_resist_default;
}
