#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "CS_QuoteGravity.h"
#include "CS_PuppyWater.h"
#include "CS_PuppyControl.h"
#include "CS_PuppyResist.h"
#include "CS_PuppyJump.h"
#include "CS_PuppyStand.h"
#include "CS_PuppyMove.h"
#include "CS_PuppyAir.h"
#include "CS_PuppyHurt.h"
#include "CS_PuppyBite.h"
#define CS_PUPPY_CREATENAME L"CS_mychar_puppy"
//Npcҽɫ СܲǿϷ
class CS_Puppy :
    public MyCharEntity
{
public:
    CS_Puppy();
    void Init(std::weak_ptr<Entity> self) override;
    void Step() override;
    void SetState(int stateID, int lr) override;
    void SetState(std::wstring stateName, int lr) override;
    void LoadSaveData() override;//ر
    void WriteSaveData() override;//д뱣
    bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
    void Gain(std::weak_ptr<Entity> item) override;
    void Destroy() override;
    void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
    void CheckResetFollowTarget();
    void ResetFollowTarget();
    //ͼʾ
    float animation_moveSpeed = 0x200 / ts;
    bool animation_delay = false;//·ӳһ֡뵽
    //״̬ģ
    EntityStateFlashEffect stateFlash;
    EntityStateInvincible stateInvincible;
    CS_QuoteGravity stateGravity;
    CS_PuppyWater stateWater;
    CS_PuppyControl stateControl;
    CS_PuppyResist stateResist;
    CS_PuppyJump stateJump;
    CS_PuppyStand stateStand;
    CS_PuppyMove stateMove;
    CS_PuppyAir stateAir;
    CS_PuppyHurt stateHurt;
    //ģ
    CS_PuppyBite skillBite;
};

std::shared_ptr<Entity> CreateCS_Puppy();