#include "CS_PeLevelUp.h"

CS_PeLevelUp::CS_PeLevelUp()
{
	type = 3;
	ani.png = L"CS_CaveStoryMod";
	topDraw = true;
}

void CS_PeLevelUp::Step()
{
	ani.sprite_index = lr == 0 ? L"pe_level_up" : L"pe_level_down";
	++ani_wait;
	vy = 0;
	if (lr == 0)
	{
		if (ani_wait < 20)
			vy = -0x400 / ts;
		if (ani_wait == 80)
			Destroy();
	}
	else
	{
		if (ani_wait < 20)
			vy = -0x200 / ts;
		if (ani_wait == 80)
			Destroy();
	}
	//ִ˶
	Entity::Step();
	ani.image_index = ani_wait / 2 % 2;
}

void SetCS_PeLevelUp(std::shared_ptr<Entity> parent, float x, float y)
{
	auto pe = std::make_shared<CS_PeLevelUp>();
	pe->x = x;
	pe->y = y;
	parent->gameFunc->SetEntity(parent, pe);
	parent->gameFunc->PlaySound(L"CS_027_level_up");
}

void SetCS_PeLevelDown(std::shared_ptr<Entity> parent, float x, float y)
{
	auto pe = std::make_shared<CS_PeLevelUp>();
	pe->x = x;
	pe->y = y;
	pe->lr = 1;
	parent->gameFunc->SetEntity(parent, pe);
}
