#include "CS_PeFireworksBomb.h"
#include "CS_PeFireworksSpark.h"
CS_PeFireworksBomb::CS_PeFireworksBomb()
{
	type = 3;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"pe_fireworks_bomb";
	ani.image_index = Random(0, 11);
}

void CS_PeFireworksBomb::Init(std::weak_ptr<Entity> self)
{
	//ù
	auto wpeLight = std::make_shared<CS_PeLightFade>();
	peLight = wpeLight;
	gameFunc->SetEntity(shared_from_this(), wpeLight);
	wpeLight->SetRadius(1);
	wpeLight->last_x = wpeLight->x = x;
	wpeLight->last_y = wpeLight->y = y;
	Entity::Init(self);
}

void CS_PeFireworksBomb::Step()
{
	if (explode_counter > 0)
	{
		explode_counter--;
		if (explode_counter == 0)
			Explode();
	}
	//βЧ
	
	//ִ˶
	Entity::Step();
	//
	auto wpeLight = peLight.lock();
	if (wpeLight)
	{
		wpeLight->x = x;
		wpeLight->last_x = last_x;
		wpeLight->y = y;
		wpeLight->last_y = last_y;
	}
}

void CS_PeFireworksBomb::Destroy()
{
	auto wpeLight = peLight.lock();
	if (wpeLight)
		wpeLight->Destroy();
	Entity::Destroy();
}

void CS_PeFireworksBomb::Shoot(float dir_x, float dir_y)
{
	float shootSpeed = Random(0x600, 0x700) / ts;
	vx = shootSpeed * dir_x;
	vy = shootSpeed * dir_y;
	//ñըʱ
	explode_counter = Random(60, 80);
}

void CS_PeFireworksBomb::Explode()
{
	//
	float shootSpeed = Random(0x1200, 0x1400) / ts;
	for (int r = 0; r < 90; r += 15)
	{
		int num = Random(10, 20);
		for (int i = 0; i < num; i++)
		{
			float radian = Random(0, 360) * deg2rad;
			float dirX = cosf(radian);
			float dirY = sinf(radian);
			SetCS_PeFireworksSpark(shared_from_this(), x, y, dirX, dirY, cosf(r * deg2rad) * shootSpeed);
		}
	}
	gameFunc->PlaySound(L"CS_023_thud");
	Destroy();
}

void SetCS_PeFireworksBomb(std::shared_ptr<Entity> parent, float x, float y, float dir_x, float dir_y)
{
	auto pe = std::make_shared<CS_PeFireworksBomb>();
	pe->x = x;
	pe->y = y;
	pe->Shoot(dir_x, dir_y);
	parent->gameFunc->SetEntity(parent, pe);
}

