#include "CS_OrangeBell.h"

CS_OrangeBell::CS_OrangeBell()
{
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 10;
	cbRect.waterBlock = true;
}

void CS_OrangeBell::Init(std::weak_ptr<Entity> self)
{
	auto wlight = std::make_shared<CS_PeLightFade>();
	light = wlight;
	gameFunc->SetEntity(shared_from_this(), wlight);
	Entity::Init(self);
}

void CS_OrangeBell::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		tgt_x = x;
		tgt_y = y;
		vy = 0x200 / ts;
	case 1:
		if (cbRect.cbLeft)
			lr = 1;
		if (cbRect.cbRight)
			lr = 0;
		if (lr == 0)
			vx = -0x100 / ts;
		else
			vx = 0x100 / ts;
		if (y < tgt_y)
			vy += 16 / ts;
		else
			vy -= 16 / ts;
		if (vy > 0x200 / ts)
			vy = 0x200 / ts;
		if (vy < -0x200 / ts)
			vy = -0x200 / ts;
		if (++ani_wait > 5)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 2)
			ani_no = 0;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_orangebell_l" : L"ls_orangebell_r";
	auto wlight = light.lock();
	if (wlight)
	{
		wlight->x = x;
		wlight->y = y;
		wlight->last_x = last_x;
		wlight->last_y = last_y;
		wlight->SetRadius(4);
	}
}

void CS_OrangeBell::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_orangebell_l" : L"ls_orangebell_r";
}

void CS_OrangeBell::Destroy()
{
	auto wlight = light.lock();
	if (wlight)
		wlight->Destroy();
	Entity::Destroy();
}

std::shared_ptr<Entity> CreateCS_OrangeBell()
{
	return std::make_shared<CS_OrangeBell>();
}
