#include "CS_KanpaFishingBladeHitbox.h"
#include "CS_KanpaFishingBlade.h"
CS_KanpaFishingBladeHitbox::CS_KanpaFishingBladeHitbox(std::shared_ptr<Entity> parent, float difficulty)
{
	attackParent = parent;
	topDraw = true;
	SetDifficulty(difficulty);
	StartHit();
}

void CS_KanpaFishingBladeHitbox::Step()
{
	DrawJudgeHitBox();
	//ƶ
	if (hitPlace < 2)
		hitPlace += hitSpeed;
	if (bHit)
	{
		//Ч
		hitRectRadius += (hitRectRadius_max - hitRectRadius) / 16.0f;
	}
	if (bLeave)
	{
		if (hitboxAlpha > 0)
		{
			hitboxAlpha -= 0.02f;
			if (hitboxAlpha < 0)
				hitboxAlpha = 0;
		}
		else
			Destroy();
	}
	else
	{
		auto wattackParent = attackParent.lock();
		if (wattackParent)
		{
			//ж
			auto wattackParent_attackParent = wattackParent->attackParent.lock();
			if (wattackParent_attackParent)
			{
				auto& input = wattackParent_attackParent->input;
				if (input.GetAtk() || input.GetJump())
				{
					SetHit();
				}
			}
			//ʧ
			if (hitPlace > 1)
			{
				//ý
				auto fishHook = std::static_pointer_cast<CS_KanpaFishingBlade>(wattackParent);
				fishHook->hitResult = hitResult;
				fishHook->bHit = true;
				bLeave = true;
			}
		}
		else
		{
			bLeave = true;
		}
	}
	//͸
	if (hitPlace > -1 && hitPlace < 0)
		indexAlpha = 1 - abs(hitPlace);
	else if (hitPlace >= 0 && hitPlace <= 1)
		indexAlpha = 1;
	else if(hitPlace > 1 && hitPlace < 2)
		indexAlpha = 2 - hitPlace;
	else
		indexAlpha = 0;
}

void CS_KanpaFishingBladeHitbox::DeltaTime(float deltaTime)
{
	//λ
	if (lineList.size() < lineList_set_last.size())
		lineList.resize(lineList_set_last.size());
	for (int i = 0; i < lineList_set_last.size(); i++)
	{
		auto& dst = lineList[i];
		auto& src_last = lineList_set_last[i];
		auto& src = lineList_set[i];
		dst.x = lerp(src_last.x, src.x, deltaTime);
		dst.y = lerp(src_last.y, src.y, deltaTime);
		dst.c = src.c;
	}
	if (fillList.size() < fillList_set_last.size())
		fillList.resize(fillList_set_last.size());
	for (int i = 0; i < fillList_set_last.size(); i++)
	{
		auto& dst = fillList[i];
		auto& src_last = fillList_set_last[i];
		auto& src = fillList_set[i];
		dst.x = lerp(src_last.x, src.x, deltaTime);
		dst.y = lerp(src_last.y, src.y, deltaTime);
		dst.c = src.c;
	}
	Entity::DeltaTime(deltaTime);
}

void CS_KanpaFishingBladeHitbox::SetDifficulty(float difficulty)
{
	//ѶӰС  ٶ
	float width = Random(49, 50) / 100.0f;//%10 - %50
	width *= (1 - difficulty);
	float dx = Random(-30, 30) /100.0f;
	hitboxRange_min = max(0, 0.5f + dx - width / 2);
	hitboxRange_max = min(1, 0.5f + dx + width / 2);
}

void CS_KanpaFishingBladeHitbox::StartHit()
{
	//ʼλ
	hitPlace = -1;
	hitSpeed = 0.02f;
	bHit = false;
}

void CS_KanpaFishingBladeHitbox::SetHit()
{
	bLeave = true;
	//ڷΧжɹ
	hitResult = hitPlace >= hitboxRange_min && hitPlace <= hitboxRange_max;
	bHit = true;
	hitSpeed = 0;
	//ý
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		auto fishHook = std::static_pointer_cast<CS_KanpaFishingBlade>(wattackParent);
		fishHook->hitResult = hitResult;
		fishHook->bHit = true;
	}
}

void CS_KanpaFishingBladeHitbox::DrawJudgeHitBox()
{
	lineList_set_last.swap(lineList_set);
	fillList_set_last.swap(fillList_set);

	DWORD fillColor = RGBA(0x80, 0, 0, (UINT8)(hitboxAlpha * 0xff));
	DWORD outlineColor = RGBA(0xff, 0, 0, (UINT8)(hitboxAlpha * 0xff));
	DWORD hitboxColor = RGBA(0xae, 0xae, 0x1c, (UINT8)(hitboxAlpha * 0xff));
	DWORD indexColor = RGBA(0xff, 0xff, 0xff, (UINT8)(hitboxAlpha * indexAlpha * 0xff));
	float left, right, top, bottom;
	float dx = 0;
	float dy = -16;
	left = -32 + dx;
	right = 32 + dx;
	top = -4 + dy;
	bottom = 4 + dy;
	float width = abs(left) + abs(right);
	int fillIndex = AddFillRect(fillList_set, 0, left, top, right, bottom, fillColor, fillColor, fillColor, fillColor);
	fillIndex += AddFillRect(fillList_set, fillIndex, left - width / 2, top, right - width, bottom, 0, fillColor, 0, fillColor);
	fillIndex += AddFillRect(fillList_set, fillIndex, left + width, top, right + width / 2, bottom, fillColor, 0, fillColor, 0);
	

	/*int lineIndex = AddLine(0, left - width / 2, top, outlineColor, right + width / 2, top, outlineColor);
	lineIndex += AddLine(lineIndex, left - width / 2, bottom, outlineColor, right + width / 2, bottom, outlineColor);*/
	//
	fillIndex += AddFillRect(fillList_set, fillIndex, (hitboxRange_min * width - width / 2), top, (hitboxRange_max * width - width / 2), bottom,
		hitboxColor, hitboxColor, hitboxColor, hitboxColor);
	//ƻ
	float indexW = 0.005f;
	fillIndex += AddFillRect(fillList_set, fillIndex, ((hitPlace - indexW) * width - width / 2), top - 8, ((hitPlace + indexW) * width - width / 2), bottom + 8,
		indexColor, indexColor, indexColor, indexColor);
	//Ч
	float r = (bottom - top + 16);
	int lineIndex = AddRect(lineList_set, 0, ((hitPlace - indexW) * width - width / 2) - hitRectRadius,
		top - 8 - hitRectRadius,
		((hitPlace + indexW) * width - width / 2) + hitRectRadius,
		bottom + 8 + hitRectRadius,
		indexColor, indexColor, indexColor, indexColor);

}
