#include "CS_IronheadAni.h"

CS_IronheadAni::CS_IronheadAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 28;
	cbRect.top = 11;
	cbRect.bottom = 12;
	drawBeforeOtherEntity = true;
}

void CS_IronheadAni::Step()
{
	switch (stateID)
	{
	case 0://ԭػζ
		ani.image_counter_speed = 0.1f;
		if (floatSrcY < y)
			vy -= 3 / ts;
		if (floatSrcY > y)
			vy += 3 / ts;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
}

void CS_IronheadAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	switch (stateID)
	{
	case 0:
		floatSrcY = y;
		vx = 0;
		vy = -0x100 / ts;
		ani.sprite_index = lr == 0 ? L"mc_ironhead_l" : L"mc_ironhead_r";
		break;
	case 1://ˮƽֱӾ
		animation_delay = true;
		if (lr == 0)
			vx = -animation_moveSpeed;
		else
			vx = animation_moveSpeed;
		vy = 0;
		ani.sprite_index = lr == 0 ? L"mc_ironhead_l" : L"mc_ironhead_r";
		break;
	case 2://ֱֹͣǰ
		vx = 0;
		this->stateID = 0;
		ani.sprite_index = lr == 0 ? L"mc_ironhead_l" : L"mc_ironhead_r";
		break;
	case 3://ϵ
		vx = vy = 0;
		ani.sprite_index = L"mc_ironhead_lie";
		break;
	case 4://
		vx = vy = 0;
		ani.sprite_index = L"mc_ironhead_struggle";
		break;
	case 5://ϵ Ⱦɫ
		vx = vy = 0;
		ani.sprite_index = L"mc_ironhead_lie_dyed";
		break;
	case 6://
		vx = vy = 0;
		ani.sprite_index = L"mc_ironhead_struggle_dyed";
		break;
	case 7://ϵ ɫ
		vx = vy = 0;
		ani.sprite_index = L"mc_ironhead_red_lie";
		break;
	}
}

void CS_IronheadAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
	{
		if (stateID != 0)
			SetState(0, lr);
		else
			this->lr = lr;
	}
	else if (stateName == L"swim")
		SetState(1, lr);
	else if (stateName == L"swim_stop")
		SetState(2, lr);
	else if (stateName == L"lie")
		SetState(3, lr);
	else if (stateName == L"struggle")
		SetState(4, lr);
	else if (stateName == L"lie_dyed")
		SetState(5, lr);
	else if (stateName == L"struggle_dyed")
		SetState(6, lr);
	else if (stateName == L"red_lie")
		SetState(7, lr);
}

std::shared_ptr<Entity> CreateCS_IronheadAni()
{
	return std::make_shared<CS_IronheadAni>();
}
