#include "CS_Helicopter.h"

CS_Helicopter::CS_Helicopter()
{
	ani.png = L"CS_CaveStoryMod";
	//þ
	cbRect.left = cbRect.right = 16;
	cbRect.top = 5;
	cbRect.bottom = 8;
	cbRect.enableCbRect = true;
	drawBeforeOtherEntity = true;
}

CS_Helicopter::~CS_Helicopter()
{
	if (channelID != -1)
		gameFunc->StopLoopSound(channelID);
}

void CS_Helicopter::Step()
{
	switch (stateID)
	{
	case 0:
		if (cbRect.cbBottom)
		{
			vy = 0;
			if (bLanding)
			{
				bLanding = false;
				//ֹͣ
				stop_delay = 120;
			}
		}
		//ִײ
		Entity::Collision();
		break;
	case 4:
		if (hover_x < x)
			vx -= 0x1 / ts;
		if (hover_x > x)
			vx += 0x1 / ts;
		if (hover_y < y)
			vy -= 0x1 / ts;
		if (hover_y > y)
			vy += 0x1 / ts;
		//ٶ
		if (vx > 0x50 / ts)
			vx = 0x50 / ts;
		if (vx < -0x50 / ts)
			vx = -0x50 / ts;

		if (vy > 0x50 / ts)
			vy = 0x50 / ts;
		if (vy < -0x50 / ts)
			vy = -0x50 / ts;
		break;
	case 5://½
		if (cbRect.cbBottom)
		{
			vy = 0;
			stateID = 0;
			if (bLanding)
			{
				bLanding = false;
				//ֹͣ
				stop_delay = 120;
			}
		}
		//ִײ
		Entity::Collision();
		break;
	case 6://
		if (leave_delay > 0)
			leave_delay--;
		if (leave_delay == 0)
			vy -= 0x1 / ts;
		if (vy < -0x80 / ts)
			vy = -0x80 / ts;
		break;
	}
	//ִ˶
	Entity::Step();

	//½ĽҶֹͣת
	if (stop_delay > 0)
	{
		stop_delay--;
		if (stop_delay == 0)
			SetState(0, lr);
	}
}

void CS_Helicopter::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	switch (stateID)
	{
	case 0://Ҷֹͣת
		if (lr == 0)
		{
			cbRect.left = 8;
			cbRect.right = 24;
		}
		else
		{
			cbRect.left = 24;
			cbRect.right = 8;
		}
		ani.sprite_index = lr == 0 ? L"ls_helicopter_stand_l" : L"ls_helicopter_stand_r";
		if (bPlay)
		{
			bPlay = false;
			if (channelID != -1)
				gameFunc->StopLoopSound(channelID);
			channelID = -1;
		}
		break;
	case 1://Ҷת
		ani.sprite_index = lr == 0 ? L"ls_helicopter_fly_l" : L"ls_helicopter_fly_r";
		if (!bPlay)
		{
			bPlay = true;
			if (!bMute)
				channelID = gameFunc->PlayLoopSound(L"CS_058");
		}
		break;
	case 2://
		cbRect.enableSelfSoild = true;
		cbRect.enableMovePlatform = true;
		break;
	case 3://ȡ
		cbRect.enableSelfSoild = false;
		cbRect.enableMovePlatform = false;
		break;
	case 4://ͣ
		{
			hover_x = x;
			hover_y = y;
			float angle = (float)Random(0, 30);
			vx = cosf(angle * deg2rad);
			vy = sinf(angle * deg2rad)*1.2f;
		}
		break;
	case 5://½
		bLanding = true;
		vy = 0x100 / ts;
		break;
	case 6://
		ani.sprite_index = lr == 0 ? L"ls_helicopter_fly_l" : L"ls_helicopter_fly_r";
		if (!bPlay)
		{
			bPlay = true;
			if (!bMute)
				channelID = gameFunc->PlayLoopSound(L"CS_058");
		}
		leave_delay = 120;
		break;
	}
}

void CS_Helicopter::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal" || stateName == L"stop")
		SetState(0, lr);
	else if (stateName == L"fly")
		SetState(1, lr);
	else if (stateName == L"set_manned")
		SetState(2, lr);
	else if (stateName == L"unset_manned")
		SetState(3, lr);
	else if (stateName == L"hover")
		SetState(4, lr);
	else if (stateName == L"landing")
		SetState(5, lr);
	else if (stateName == L"leave")
		SetState(6, lr);
	else if (stateName == L"mute")
		bMute = true;
	
}

std::shared_ptr<Entity> CreateCS_Helicopter()
{
	return std::make_shared<CS_Helicopter>();
}
