#include "CS_Fan_Down.h"
#include "CS_PeWaterParticles.h"

CS_Fan_Down::CS_Fan_Down()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_fan_down";
	drawBeforeOtherEntity = true;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
}

void CS_Fan_Down::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		if (lr == 1)
			act_no = 2;
		else
			ani_no = 1;
		[[fallthrough]];
	case 1:
		ani_no = 0;
		break;

	case 2:
		if (++ani_wait > 0)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 2)
			ani_no = 0;
		if (gameFunc->GetGlobalEntityTable)
		{
			auto& table = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto& p : table)
			{
				auto wplayer = p.second.lock();
				if (wplayer)
				{
					if (wplayer->el.name == L"null")
						continue;
					if (wplayer->x < x + 0x1000 / ts && wplayer->x > x - 0x1000 / ts && wplayer->y < y + 0xC000 / ts && wplayer->y > y)
						wplayer->vy += 0x88 / ts;
				}
			}
		}
		if (Random(0, 5) == 1)
			SetCS_PeWaterParticles(shared_from_this(), x + Random(-8, 8), y, 3);
		break;
	}
}

void CS_Fan_Down::SetState(int stateID, int lr)
{
	this->lr = lr;
}

std::shared_ptr<Entity> CreateCS_Fan_Down()
{
	return std::make_shared<CS_Fan_Down>();
}
