#include "CS_Enemy_SandDragon.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Enemy_SandDragonBlade.h"
CS_Enemy_SandDragon::CS_Enemy_SandDragon()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = 6;
	cbRect.top = 6;
	cbRect.bottom = 6;
	hp_max = hp = 15;
	dropExp = 10;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_SandDragon::Init(std::weak_ptr<Entity> self)
{
	auto we = std::make_shared<Entity>();
	we->ani.png = L"";
	we->ani.sprite_index = L"ls_sanddragon_sand";
	we->x = x;
	we->y = y;
	sand = we;
	gameFunc->SetEntity(shared_from_this(), we);
	//س
	if (bInvert)
	{
		we->y -= 8;
		srcY = y - 16;
		dstY = y + 4;
	}
	else
	{
		we->y += 8;
		srcY = y + 16;
		dstY = y - 4;
	}
	Entity::Init(self);
}

void CS_Enemy_SandDragon::Step()
{
	Entity::Step();
	if (appear_interval_counter > 0)
		appear_interval_counter--;
	else if (bHide)
	{
		//ڵ
		last_y = y = srcY;
		ani.image_index = 0;
		auto wsand = sand.lock();
		if (wsand)
			wsand->ani.png = L"";
		if (gameFunc->GetPlayerDistanceWithLineTest)
		{
			float DY = bInvert ? 16.0f : -16.0f;
			auto wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y + DY).lock();
			if (wplayer)
			{
				//ҿʱ
				if (abs(wplayer->x - x) <= 128 && abs(wplayer->y - y) <= 128)
				{
					//
					if (x > wplayer->x)
						lr = 0;
					else
						lr = 1;
					//֣׼
					bHide = false;
					bShow = true;
					target_lost_counter = target_lost_counter_max;
					appear_counter = appear_counter_max;
					shot_counter = Random(2, 4);
					gameFunc->PlaySound(L"CS_sea_enemy_appear");
				}
			}
		}
	}
	else
	{
		if (bShow)
		{
			if (appear_counter > 0)
			{
				appear_counter--;
				auto wsand = sand.lock();
				if (wsand)
					wsand->ani.png = L"CS_CaveStoryMod";
				ani.image_index = 1;
			}
			else
			{
				auto wsand = sand.lock();
				if (wsand)
					wsand->ani.png = L"";
			}
			y = lerp(srcY, dstY, (float)(appear_counter_max - appear_counter) / appear_counter_max);

			if (hideWait_counter > 0)
				hideWait_counter--;
			if (appear_counter == 0)
			{
				std::shared_ptr<Entity> wplayer;
				if (gameFunc->GetPlayerDistanceWithLineTest)
					wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					target_lost_counter = target_lost_counter_max;
					if (shot_interval_counter > 0)
					{
						ani.image_index = 2;
						shot_interval_counter--;

					}
					else
					{
						ani.image_index = 0;
					}
					if (shot_counter > 0)
					{
						//Ŀɹҽ
						if (shot_interval_counter == 0)
						{
							shot_interval_counter = shot_interval_counter_max;
							shot_counter--;
							if (shot_counter == 0)
								hideWait_counter = 60;
							//
							gameFunc->PlaySound(L"CS_sea_enemy_shot1");
							XMVECTOR vec = XMVector2Normalize(XMVectorSet(wplayer->x - x, wplayer->y - y, 0, 0));
							SetCS_Enemy_SandDragonBlade(shared_from_this(),
								x + (lr == 0 ? -8.0f : 8.0f),
								y,
								shotSpeed * XMVectorGetX(vec),
								shotSpeed * XMVectorGetY(vec));
						}
					}
					//ӵľ
					else if(hideWait_counter == 0)
					{
						//ص
						bShow = false;
						gameFunc->PlaySound(L"CS_sea_enemy_disappear");
					}
				}
				//Ŀ궪ʧ
				else
				{
					shot_counter = 0;
					shot_interval_counter = 0;
					if (target_lost_counter <= target_lost_counter_max - shot_interval_counter_max)
						ani.image_index = 0;
					if (target_lost_counter > 0)
						target_lost_counter--;
					if (target_lost_counter == 0)
					{
						//ص
						bShow = false;
						gameFunc->PlaySound(L"CS_sea_enemy_disappear");
					}
				}
			}
		}
		//׼ȫص
		else
		{
			ani.image_index = 0;
			if (appear_counter < appear_counter_max)
			{
				appear_counter++;
				auto wsand = sand.lock();
				if (wsand)
					wsand->ani.png = L"CS_CaveStoryMod";
			}
			if (appear_counter == appear_counter_max)
			{
				bHide = true;
				appear_interval_counter = appear_interval_counter_max;
				auto wsand = sand.lock();
				if (wsand)
					wsand->ani.png = L"";
			}
			y = lerp(srcY, dstY, (float)(appear_counter_max - appear_counter) / appear_counter_max);
		}
	}
	//
	if (flash_counter > 0)
	{
		if (flash_counter / 2 % 2 == 0)
			ani.png = L"";
		else
			ani.png = L"CS_CaveStoryMod";
		flash_counter--;
	}
	else
		ani.png = L"CS_CaveStoryMod";
	if (bInvert)
		ani.sprite_index = lr == 0 ? L"ls_sanddragon_lu" : L"ls_sanddragon_ru";
	else
		ani.sprite_index = lr == 0 ? L"ls_sanddragon_ld" : L"ls_sanddragon_rd";
}

void CS_Enemy_SandDragon::SetState(int stateID, int lr)
{
	this->lr = lr;
	bInvert = el.arg == L"invert";
	if (bInvert)
		ani.sprite_index = lr == 0 ? L"ls_sanddragon_lu" : L"ls_sanddragon_ru";
	else
		ani.sprite_index = lr == 0 ? L"ls_sanddragon_ld" : L"ls_sanddragon_rd";
}

void CS_Enemy_SandDragon::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_SandDragon::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (bHide)
		return false;
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	flash_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_sea_enemy_hurt2");
	}
	else
	{
		gameFunc->PlaySound(L"CS_sea_destroy1");
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_SandDragon::Destroy()
{
	auto wsand = sand.lock();
	if (wsand)
		wsand->Destroy();
	Entity::Destroy();
}

void CS_Enemy_SandDragon::Appear()
{
}

void CS_Enemy_SandDragon::Disappear()
{
}

std::shared_ptr<Entity> CreateCS_Enemy_SandDragon()
{
	return std::make_shared<CS_Enemy_SandDragon>();
}
