#include "CS_Enemy_Polish.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Enemy_PolishBaby.h"
CS_Enemy_Polish::CS_Enemy_Polish()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	hp_max = hp = 20;
	dropExp = 12;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 12;
}

void CS_Enemy_Polish::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		[[fallthrough]];
	case 1:
		if (lr == 0)
			act_no = 8;
		else
			act_no = 2;
		[[fallthrough]];
	case 2:
		vy_set += 0x20 / ts;
		if (cbRect.cbBottom)
		{
			vy_set = -0x100 / ts;
			vx_set += 0x100 / ts;
		}
		if (cbRect.cbRight)
			act_no = 3;
		break;
	case 3:
		vx_set += 0x20 / ts;
		if (cbRect.cbRight)
		{
			vx_set = -0x100 / ts;
			vy_set -= 0x100 / ts;
		}
		if (cbRect.cbTop)
			act_no = 4;
		break;
	case 4:
		vy_set -= 0x20 / ts;
		if (cbRect.cbTop)
		{
			vy_set = 0x100 / ts;
			vx_set -= 0x100 / ts;
		}
		if (cbRect.cbLeft)
			act_no = 5;
		break;
	case 5:
		vx_set -= 0x20 / ts;
		if (cbRect.cbLeft)
		{
			vx_set = 0x100 / ts;
			vy_set += 0x100 / ts;
		}
		if (cbRect.cbBottom)
			act_no = 2;
		break;
	case 6:
		vy_set += 0x20 / ts;
		if (cbRect.cbBottom)
		{
			vy_set = -0x100 / ts;
			vx_set -= 0x100 / ts;
		}
		if (cbRect.cbLeft)
			act_no = 7;
		break;
	case 7:
		vx_set -= 0x20 / ts;
		if (cbRect.cbLeft)
		{
			vx_set = 0x100 / ts;
			vy_set -= 0x100 / ts;
		}
		if (cbRect.cbTop)
			act_no = 8;
		break;
	case 8:
		vy_set -= 0x20 / ts;
		if (cbRect.cbTop)
		{
			vy_set = 0x100 / ts;
			vx_set += 0x100 / ts;
		}
		if (cbRect.cbRight)
			act_no = 9;
		break;
	case 9:
		vx_set += 0x20 / ts;
		if (cbRect.cbRight)
		{
			vx_set = -0x100 / ts;
			vy_set += 0x100 / ts;
		}
		if (cbRect.cbBottom)
			act_no = 6;
		break;
	}
	if (vx_set > 0x200 / ts)
		vx_set = 0x200 / ts;
	if (vx_set < -0x200 / ts)
		vx_set = -0x200 / ts;

	if (vy_set > 0x200 / ts)
		vy_set = 0x200 / ts;
	if (vy_set < -0x200 / ts)
		vy_set = -0x200 / ts;

	if (shock_counter > 0)
	{
		vx = vx_set / 2;
		vy = vy_set / 2;
	}
	else
	{
		vx = vx_set;
		vy = vy_set;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_polish_l" : L"ls_polish_r";
	if (act_no >= 2 && act_no <= 9 && ++ani_no > 1)
		ani_no = 0;
}

void CS_Enemy_Polish::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_polish_l" : L"ls_polish_r";
}

void CS_Enemy_Polish::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Polish::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_025_funny_explode");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		//
		for (int i = 0; i < 10; ++i)
		{
			auto we = std::make_shared<CS_Enemy_PolishBaby>();
			we->x = x;
			we->y = y;
			gameFunc->SetEntity(shared_from_this(), we);
		}
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Polish()
{
	return std::make_shared<CS_Enemy_Polish>();
}
