#include "CS_Enemy_MannanBlade.h"

CS_Enemy_MannanBlade::CS_Enemy_MannanBlade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	ani.png = L"CS_CaveStoryMod";
	ud = parent->ud;
	lr = parent->lr;
	dx = lr == 0 ? -8.0f : 8.0f;
	x = parent->x + dx;
	y = parent->y + dy;
	cbRect.left = 3;
	cbRect.right = 3;
	cbRect.top = 8;
	cbRect.bottom = 8;
}

void CS_Enemy_MannanBlade::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		[[fallthrough]];
	case 1:
		if (lr == 0)
			vx -= 0x20 / ts;
		else
			vx += 0x20 / ts;

		if (++ani_wait > 0)
		{
			ani_wait = 0;
			++ani_no;
		}

		if (ani_no > 2)
			ani_no = 0;

		break;
	}
	//ִ˶
	Entity::Step();
	if (++count1 > existTime)
		Destroy();
	ani.sprite_index = lr == 0 ? L"am_mannan_l" : L"am_mannan_r";
	if (count1 % 4 == 1)
		gameFunc->PlaySound(L"CS_046_ironh_shot_fly");

}

void CS_Enemy_MannanBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void SetCS_Enemy_MannanBlade(std::shared_ptr<Entity> parent)
{
	auto am = std::make_shared<CS_Enemy_MannanBlade>(parent);
	parent->gameFunc->SetEntity(parent, am);
}
