#include "CS_Enemy_LaserTrapBlade.h"

CS_Enemy_LaserTrapBlade::CS_Enemy_LaserTrapBlade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 2;
	//
	noDir = true;
}

void CS_Enemy_LaserTrapBlade::Step()
{
	if (exist_time == 0)
		Destroy();
	if (exist_time > 0)
		exist_time--;
}

void CS_Enemy_LaserTrapBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

std::shared_ptr<CS_Enemy_LaserTrapBlade> SetCS_Enemy_LaserTrapBlade(std::shared_ptr<Entity> parent, float x, float y)
{
	auto am = std::make_shared<CS_Enemy_LaserTrapBlade>(parent);
	am->x = x;
	am->y = y;
	parent->gameFunc->SetEntity(parent, am);
	return am;
}
