#include "CS_Enemy_Hoppy.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_Hoppy::CS_Enemy_Hoppy()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = cbRect.bottom = 6;
	hp_max = hp = 10;
	dropExp = 1;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Hoppy::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		[[fallthrough]];
	case 1:
		ani_no = 0;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (wplayer->y < y + 0x10000 / ts && wplayer->y > y - 0x10000 / ts)
				{
					act_no = 10;
					act_wait = 0;
					ani_no = 1;
				}
			}
		}
		break;
	case 10:
		if (++act_wait == 4)
			ani_no = 2;
		if (act_wait > 12)
		{
			act_no = 12;
			vx = lr == 0 ? 0x1000 / ts : -0x1000 / ts;
			gameFunc->PlaySound(L"CS_006");
			ani_no = 3;
		}
		break;
	case 12:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (wplayer->y < y)
					vy = -0xAA / ts;
				else
					vy = 0xAA / ts;
			}
		}
		if (lr == 0)
		{
			if (cbRect.cbLeft)
			{
				act_no = 13;
				act_wait = 0;
				ani_no = 2;
				vx = 0;
				vy = 0;
				break;
			}
			else
			{
				vx -= 42 / ts;
				if (vx < -0x5FF / ts)
					vx = -0x5FF / ts;
			}
		}
		else
		{
			if (cbRect.cbRight)
			{
				act_no = 13;
				act_wait = 0;
				ani_no = 2;
				vx = 0;
				vy = 0;
				break;
			}
			else
			{
				vx += 42 / ts;
				if (vx > 0x5FF / ts)
					vx = 0x5FF / ts;
			}
		}
		break;
	case 13:
		++act_wait;
		if (act_wait == 2)
			ani_no = 1;
		if (act_wait == 6)
			ani_no = 0;
		if (act_wait > 16)
			act_no = 1;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_Enemy_Hoppy::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_hoppy_l" : L"ls_hoppy_r";
}

void CS_Enemy_Hoppy::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 4;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Hoppy::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_050_mimiga_squeak");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Hoppy()
{
	return std::make_shared<CS_Enemy_Hoppy>();
}
