#include "CS_Enemy_GrenadeMan.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmGrenade.h"
CS_Enemy_GrenadeMan::CS_Enemy_GrenadeMan()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 18;
	cbRect.bottom = 12;

	hp_max = hp = 64;
	dropExp = 9;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_GrenadeMan::Init(std::weak_ptr<Entity> self)
{
	y -= 4;
	Entity::Init(self);
}

void CS_Enemy_GrenadeMan::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		tgt_x = x;
		[[fallthrough]];
	case 1:
		vx = 0;
		act_no = 2;
		ani_no = 0;
		[[fallthrough]];
	case 2:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
				lr = x > wplayer->x ? 0 : 1;
		}
		if (++ani_wait > 40)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 1)
			ani_no = 0;
		if (!bStopAtk)
		{
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					if (bIgnoreAtkDistance)
					{
						act_no = 10;
					}
					else
					{
						if (abs(x - wplayer->x) <= 128 && abs(y - wplayer->y) <= 96)
							act_no = 10;
					}
				}
			}
			if (shock_counter > 0)
				act_no = 10;
		}
		break;
	case 10:
		act_no = 11;
		ani_no = 2;
		act_wait = 0;
		[[fallthrough]];
	case 11:
		if (++act_wait > 10)
		{
			act_no = 12;
			ani_no = 3;
			vy = -0x600 / ts;
			count1 = 0;
			vx = tgt_x > x ? 0x200 / ts : -0x200 / ts;
		}
		break;
	case 12:
		if (vy > 0)
		{
			ani_no = 4;
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					if (count1 == 0)
					{
						++count1;
						float dy = -0x1400 / ts;
						XMVECTOR vec = XMVector2Normalize(XMVectorSet(wplayer->x - x, wplayer->y - (y + dy), 0, 0));
						SetCS_AmGrenade(shared_from_this(), x, y + dy, 4 * XMVectorGetX(vec), 4 * XMVectorGetY(vec));
						gameFunc->PlaySound(L"CS_039_em_fire");
					}
				}
			}
		}
		if (vy > 0x200 / ts)
			ani_no = 5;
		if (cbRect.cbBottom)
		{
			ani_no = 2;
			act_no = 13;
			act_wait = 0;
			vx = 0;
		}
		break;
	case 13:
		vx /= 2;
		if (++act_wait > 10)
			act_no = 1;
		break;
	}
	vy += 0x55 / ts;
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_grenademan_l" : L"ls_grenademan_r";
}

void CS_Enemy_GrenadeMan::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->act_no = stateID;
	ani.sprite_index = lr == 0 ? L"ls_grenademan_l" : L"ls_grenademan_r";
}

void CS_Enemy_GrenadeMan::SetState(std::wstring stateName, int lr)
{
	this->lr = lr;
	if (stateName == L"stop_atk")
	{
		bStopAtk = true;
	}
	else if (L"atk")
	{
		bStopAtk = false;
		bIgnoreAtkDistance = true;
	}
}

void CS_Enemy_GrenadeMan::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_GrenadeMan::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_GrenadeMan()
{
	return std::make_shared<CS_Enemy_GrenadeMan>();
}
