#include "CS_Enemy_GolemScissors.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "PeSmog.h"
#include "CS_Enemy_GolemScissorsClone.h"
CS_Enemy_GolemScissors::CS_Enemy_GolemScissors()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_golem_scissors";
	ani.image_index = 2;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 32;
	cbRect.bottom = 8;
	hp_max = hp = 70;
	dropExp = 19;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
	speedDir = true;
}

void CS_Enemy_GolemScissors::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_GolemScissors::Step()
{
	stateGravity.Step();
	stateSplash.Step();
	if (wake_counter > 0)
	{
		wake_counter--;
	}
	switch (stateID)
	{
	case 0:
		type = 0;//αװ
		break;
	case 1://(жӳ٣
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		wake_counter = 120;
		stateID = 2;
		bAction = true;
		ani.image_index = 0;
		type = 2;//ԭ
		[[fallthrough]];
	case 2://жӳ
		if (wake_counter > 0)
			wake_counter--;
		if (wake_counter == 0)
			stateID = 3;
		break;
	case 3://ж
		//һϿշļ
		SetPeSmog(shared_from_this(), x, y, 4);
		ani.sprite_index = L"ls_golem_scissors_u";
		//ʹЧ
		vy = 1;
		if (bNormalMode)
			stateGravity.SetGravityScale(0.25f);
		else
			stateGravity.SetGravityScale(0.5f);
		stateGravity.State();
		if (bNormalMode)
		{
			vy = -0x400 / ts;
			stateGravity.SetGravityScale(0.25f);
		}
		else
		{
			vy = -0x800 / ts;
			stateGravity.SetGravityScale(0.5f);
		}
		stateID = 4;
		break;
	case 4://ֱٶ
		if (vy >= 0)
		{
			gameFunc->PlaySound(L"CS_106");
			SetPeSmog(shared_from_this(), x, y, 4);
			ani.sprite_index = L"ls_golem_scissors_d";
			int dx = 0;
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
				{
					dx = x > wplayer->x ? -0x300 : 0x300;
				}
			}
			//üѼ
			int num = 4;
			if (bNormalMode)
				num = 2;
			for (auto i = 0; i < num; i++)
			{
				if (bNormalMode)
					SetCS_Enemy_GolemScissorsClone(shared_from_this(), x, y, Random(-0x300 + dx / 4, 0x300 + dx / 4) / ts, 0);
				else
					SetCS_Enemy_GolemScissorsClone(shared_from_this(), x, y, Random(-0x600 + dx, 0x600 + dx) / ts, 0);
			}
			//
			vy = 0;
			if (bNormalMode)
			{
				vx = Random(-0x300 + dx / 4, 0x300 + dx / 4) / ts;
				stateGravity.SetGravityScale(0.5f);
			}
			else
			{
				vx = Random(-0x600 + dx, 0x600 + dx) / ts;
				stateGravity.SetGravityScale(1.0f);
			}
			stateID = 5;
		}
		break;
	case 5://ֱػָԭ״
		if (cbRect.cbBottom)
		{
			SetPeSmog(shared_from_this(), x, y, 4);
			ani.sprite_index = L"ls_golem_scissors";
			ani.image_index = 0;
			if (bNormalMode)
				moveinterval_counter = 80;//һж
			else
				moveinterval_counter = 40;//һж
			stateID = 6;
		}
		break;
	case 6://ж
		if (abs(vx) > 0.001f)
			vx /= 1.1f;
		else
			vx = 0;
		if (moveinterval_counter > 0)
			moveinterval_counter--;
		if (moveinterval_counter == 0)
			stateID = 3;
		break;
	case 7://׹
		ani.image_index = 0;
		vy += 0x20 / ts;
		if (drop_counter > 0)
		{
			drop_counter--;
			cbRect.enableCbRect = false;
			cbRect.enableSoild = false;
		}
		else
		{
			cbRect.enableCbRect = true;
			cbRect.enableSoild = true;
		}
		if (cbRect.enableSoild)
		{
			if (cbRect.cbBottom)
			{
				for (int i = 0; i < 4; i++)
				{
					auto pe = std::make_shared<CS_PeSmoke>();
					pe->x = x + Random(-12, 12);
					pe->y = y + Random(-12, 12);
					pe->vx = Random(-341, 341) / ts;
					pe->vy = Random(-0x600, 0) / ts;
					gameFunc->SetEntity(shared_from_this(), pe);
				}
				gameFunc->PlaySound(L"CS_026_quake");
				if (gameFunc->SetQuake)
					gameFunc->SetQuake(gameFunc->game, 30, 0);
				stateID = 8;
			}
		}
		//
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		break;
	case 8://
		break;
	case 9://
		ani.image_index = 1;
		if (abs(vx) > 0.001f)
			vx /= 1.1f;
		else
			vx = 0;
		break;
	}
	//ǽ
	if (cbRect.cbLeft)
		vx = abs(vx);
	if (cbRect.cbRight)
		vx = -abs(vx);
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_Enemy_GolemScissors::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (stateID < 1000)
	{
		this->stateID = stateID;
		switch (stateID)
		{
		case 3:
			type = 2;//ԭ
			break;
		}
	}
	else
	{
		this->stateID = 7;
		drop_counter = stateID - 1000;
		cbRect.enableCbRect = false;
		cbRect.enableSoild = false;
		//һײ
		Entity::ClearCollisionResult();
	}
}

void CS_Enemy_GolemScissors::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, 0);
	else if (stateName == L"wake")
		SetState(1, 0);
	else if (stateName == L"action")
	{
		bAction = true;
		SetState(3, 0);
	}
}

void CS_Enemy_GolemScissors::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (!bAction)
		return;
	if (hp <= 0)
		return;
	if (vy > 0)
		*outDamage = 10;
	else
		*outDamage = 2;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_GolemScissors::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (!bAction)
		return false;
	if (!bNormalMode)
	{
		if (elemType == 0)
		{
			if (getDamage < 5)
			{
				*outRealDamage = 0;
				return true;
			}
		}
	}
	if (stateID != 6)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		stateID = 9;
		damage_reset_counter = -1;
		attackState_reset_counter_max = -1;
		attackState = false;
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_GolemScissors()
{
	return std::make_shared<CS_Enemy_GolemScissors>();
}
