#include "CS_Enemy_FuzzCore.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Enemy_Fuzz.h"

CS_Enemy_FuzzCore::CS_Enemy_FuzzCore()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 4;
	hp_max = hp = 10;
	dropExp = 7;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_FuzzCore::Init(std::weak_ptr<Entity> self)
{
	act_no = 1;
	tgt_x = x;
	tgt_y = y;
	act_wait = Random(0, 50);
	for (int i = 0; i < 5; i++)
	{
		auto we = std::make_shared<CS_Enemy_Fuzz>();
		we->angle = 360.0f * i / 5.0f;
		we->attackParent = shared_from_this();
		gameFunc->SetEntity(shared_from_this(), we);
	}
	Entity::Init(self);
}

void CS_Enemy_FuzzCore::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
	case 1:
		if (++act_wait < 50)
			break;
		act_wait = 0;
		act_no = 2;
		vy = 0x300 / ts;
		break;
	case 2:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
				lr = wplayer->x < x ? 0 : 1;
		}
		if (tgt_y < y)
			vy -= 0x10 / ts;
		if (tgt_y > y)
			vy += 0x10 / ts;
		if (vy > 0x355 / ts)
			vy = 0x355 / ts;
		if (vy < -0x355 / ts)
			vy = -0x355 / ts;
		break;
	}
	//ִ˶
	Entity::Step();
	if (++ani_wait > 2)
	{
		ani_wait = 0;
		++ani_no;
	}
	if (ani_no > 1)
		ani_no = 0;
	ani.sprite_index = lr == 0 ? L"ls_fuzzcore_l" : L"ls_fuzzcore_r";
}

void CS_Enemy_FuzzCore::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_fuzzcore_l" : L"ls_fuzzcore_r";
}

void CS_Enemy_FuzzCore::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 1;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_FuzzCore::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_021_bubble");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_FuzzCore()
{
	return std::make_shared<CS_Enemy_FuzzCore>();
}
