#include "CS_Enemy_Fuzz.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_Fuzz::CS_Enemy_Fuzz()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 4;
	hp_max = hp = 8;
	dropExp = 1;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Fuzz::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		count1 = lr == 0 ? 0 : 2;
		[[fallthrough]];
	case 1:
		if (attackParent.expired())
		{
			vx = Random(-0x200, 0x200) / ts;
			vy = Random(-0x200, 0x200) / ts;
			act_no = 10;
		}
		else
		{
			auto wattackParent = attackParent.lock();
			last_x = x;
			last_y = y;
			x = wattackParent->x + 20 * sinf(angle * deg2rad);
			y = wattackParent->y + 0x20 * cosf(angle * deg2rad);
			angle += 360.0f / 64.0f;
			if (angle > 360.0f)
				angle -= 360.0f;
		}
		break;
	case 10:
		speedDir = true;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (wplayer->x < x)
					vx -= 0x20 / ts;
				else
					vx += 0x20 / ts;

				if (wplayer->y < y)
					vy -= 0x20 / ts;
				else
					vy += 0x20 / ts;
			}
		}
		if (vx > 0x800 / ts)
			vx = 0x800 / ts;
		if (vx < -0x800 / ts)
			vx = -0x800 / ts;
		if (vy > 0x200 / ts)
			vy = 0x200 / ts;
		if (vy < -0x200 / ts)
			vy = -0x200 / ts;
		//ִ˶
		Entity::Step();
		break;
	}
	if (gameFunc->GetPlayerDistance)
	{
		auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
		if (wplayer)
			lr = wplayer->x < x ? 0 : 1;
	}
	if (++ani_wait > 2)
	{
		ani_wait = 0;
		++ani_no;
	}
	if (ani_no > 1)
		ani_no = 0;
	ani.sprite_index = lr == 0 ? L"ls_fuzz_l" : L"ls_fuzz_r";
}

void CS_Enemy_Fuzz::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_fuzz_l" : L"ls_fuzz_r";
}

void CS_Enemy_Fuzz::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 1;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Fuzz::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_021_bubble");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Fuzz()
{
	return std::make_shared<CS_Enemy_Fuzz>();
}
