#include "CS_Enemy_Crow_SkullheadCatcher.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_Enemy_Skullhead.h"
CS_Enemy_Crow_SkullheadCatcher::CS_Enemy_Crow_SkullheadCatcher()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	hp_max = hp = 20;
	dropExp = 9;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Crow_SkullheadCatcher::Init(std::weak_ptr<Entity> self)
{
	tgt_x = x;
	tgt_y = y;
	srcLR = lr;
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Crow_SkullheadCatcher::Step()
{
	auto& ani_no = ani.image_index;
	stateSplash.Step();
	if (!bCaught)
	{
		auto wskullhead = skullhead.lock();
		//صԭ
		if (bSetBack)
		{
			//ԭ㷵
			if (abs(x - tgt_x) <= 4 && abs(y - tgt_y) <= 4)
			{
				bSetBack = false;
				vy = 0x400 / ts;
				vx = 0;
				lr = srcLR;
			}
			else if (abs(x - tgt_x) <= 64 && abs(y - tgt_y) <= 64)
			{
				float dirX;
				float dirY;
				Pathfinding(tgt_x, tgt_y, &dirX, &dirY);
				vx = dirX * 200 / ts;
				vy = dirY * 200 / ts;
			}
			else
			{
				float dirX;
				float dirY;
				Pathfinding(tgt_x, tgt_y, &dirX, &dirY);
				vx += dirX * 20 / ts;
				vy += dirY * 20 / ts;
			}
			if (vx > 0x200 / ts)
				vx = 0x200 / ts;
			if (vx < -0x200 / ts)
				vx = -0x200 / ts;
			if (vy > 0x200 / ts)
				vy = 0x200 / ts;
			if (vy < -0x200 / ts)
				vy = -0x200 / ts;
			if (vx < 0)
				lr = 0;
			else
				lr = 1;
		}
		else if (wskullhead)
		{
			if (wskullhead->inUsing)
			{
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						if (wplayer->x < x)
							lr = 0;
						else
							lr = 1;
					}
				}
				//ץסͷ
				if (tgt_y < y)
					vy -= 10 / ts;
				if (tgt_y > y)
					vy += 10 / ts;
				if (vy > 0x200 / ts)
					vy = 0x200 / ts;
				if (vy < -0x200 / ts)
					vy = -0x200 / ts;
			}
			else
			{
				skullhead.reset();
			}
		}
		else
		{
			float dis = 9999;
			//ͼǷSkullhead
			std::weak_ptr<CS_Enemy_Skullhead> sk;
			for (auto& e : entityLayer->Am)
			{
				if (e->el.name == CS_ENEMY_SKULLHEAD_CREATENAME)
				{
					auto head = std::static_pointer_cast<CS_Enemy_Skullhead>(e);
					//Ѿѻץס
					if (!head->pCrow.expired())
						continue;
					//Ѱ·
					auto path = gameFunc->GetPath(shared_from_this(), e->x / 16, e->y / 16, x / 16, y / 16);
					//ڵͼϱ
					if (path->dis == 0 && path->vec1_x == 0 && path->vec1_y == 0)
						continue;
					if (path->dis < dis)
					{
						dis = path->dis;
						sk = std::static_pointer_cast<CS_Enemy_Skullhead>(e);
					}
				}
			}
			auto wsk = sk.lock();
			if (wsk)
			{
				if (Touch(wsk))
				{
					//ͷ
					skullhead = wsk;
					wsk->pCrow = std::static_pointer_cast<CS_Enemy_Crow_SkullheadCatcher>(shared_from_this());
					bSetBack = true;
				}
				else
				{
					//Եͷǵĵص
					float dirX;
					float dirY;
					Pathfinding(wsk->x, wsk->y, &dirX, &dirY);
					vx += dirX * 20 / ts;
					vy += dirY * 20 / ts;
					if (vx > 0x200 / ts)
						vx = 0x200 / ts;
					if (vx < -0x200 / ts)
						vx = -0x200 / ts;
					if (vy > 0x200 / ts)
						vy = 0x200 / ts;
					if (vy < -0x200 / ts)
						vy = -0x200 / ts;
					if (vx < 0)
						lr = 0;
					else
						lr = 1;
				}
			}
		}
		if (cbRect.cbLeft && wskullhead && !bSetBack)
			vx = 0x200 / ts;
		if (cbRect.cbRight && wskullhead && !bSetBack)
			vx = -0x200 / ts;
		if (cbRect.cbTop && wskullhead && !bSetBack)
			vy = 0x200 / ts;
		if (cbRect.cbBottom && wskullhead && !bSetBack)
			vy = -0x200 / ts;
		if (vx > 0x5FF / ts)
			vx = 0x5FF / ts;
		if (vx < -0x5FF / ts)
			vx = -0x5FF / ts;
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		//һײ
		Entity::ClearCollisionResult();
		//ִ˶
		Entity::Step();
		//ִײ
		Entity::Collision();
	}
	if (shock_counter > 0)
	{
		ani_no = 2;
	}
	else
	{
		if (++ani_wait > 1)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 1)
			ani_no = 0;
	}
	ani.sprite_index = lr == 0 ? L"ls_crow_l" : L"ls_crow_r";
}

void CS_Enemy_Crow_SkullheadCatcher::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_crow_l" : L"ls_crow_r";
}

void CS_Enemy_Crow_SkullheadCatcher::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 4;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Crow_SkullheadCatcher::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::weak_ptr<Entity> CS_Enemy_Crow_SkullheadCatcher::BeginCaught(std::weak_ptr<Entity> e)
{
	//ץſ
	auto wskullhead = skullhead.lock();
	if (wskullhead)
	{
		wskullhead->pCrow.reset();
		wskullhead->act_no = 3;
		wskullhead->vx = 0;
		wskullhead->vy = 0;
		wskullhead->count2 = 1;
		skullhead.reset();
		bSetBack = false;
	}
	bCaught = true;
	return shared_from_this();
}

void CS_Enemy_Crow_SkullheadCatcher::EndCaught(std::weak_ptr<Entity> e)
{
	bCaught = false;
	bSetBack = true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Crow_SkullheadCatcher()
{
	return std::make_shared<CS_Enemy_Crow_SkullheadCatcher>();
}
