#include "CS_DeathTrap.h"

CS_DeathTrap::CS_DeathTrap()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_deathtrap";
	drawBeforeOtherEntity = true;
	cbRect.left = 6;
	cbRect.right = 22;
	cbRect.top = 8;
	cbRect.bottom = 8;
	noDir = true;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	isTrap = true;
	ignoreCaught = true;
}

void CS_DeathTrap::Step()
{
	attackState = true;
}

void CS_DeathTrap::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->ignoreTrap_counter > 0)
			return;
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outDamage = 127;
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x400 / ts;
	*outHeavy = 2;
}

void CS_DeathTrap::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	auto wdst = target.lock();
	if (wdst)
	{
		if(realDamage > 0)
			wdst->ignoreTrap_counter = 180;
	}
}

std::shared_ptr<Entity> CreateCS_DeathTrap()
{
	return std::make_shared<CS_DeathTrap>();
}
