#include "CS_Boss_TalaBlade.h"

CS_Boss_TalaBlade::CS_Boss_TalaBlade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	ani.png = L"CS_CaveStoryMod";
	ud = parent->ud;
	cbRect.left = 3;
	cbRect.right = 3;
	cbRect.top = 8;
	cbRect.bottom = 8;
}

void CS_Boss_TalaBlade::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		[[fallthrough]];
	case 1:
		vx += dir_x * 0x20 / ts;
		vy += dir_y * 0x20 / ts;
		if (++ani_wait > 0)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 2)
			ani_no = 0;
		break;
	}
	//ִ˶
	Entity::Step();
	if (++count1 > existTime)
		Destroy();
	
	if (count1 % 4 == 1)
		gameFunc->PlaySound(L"CS_046_ironh_shot_fly");
	ani.sprite_index = lr == 0 ? L"am_tala_l" : L"am_tala_r";
}

void CS_Boss_TalaBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 1;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void SetCS_Boss_TalaBlade(std::shared_ptr<Entity> parent, float x, float y, float dir_x, float dir_y)
{
	auto am = std::make_shared<CS_Boss_TalaBlade>(parent);
	am->x = x;
	am->y = y;
	am->dir_x = dir_x;
	am->dir_y = dir_y;
	am->lr = dir_x < 0 ? 0 : 1;
	parent->gameFunc->SetEntity(parent, am);
}
