#include "CS_Boss_SoapKingMagicFloor_PressWall.h"

CS_Boss_SoapKingMagicFloor_PressWall::CS_Boss_SoapKingMagicFloor_PressWall(std::shared_ptr<Entity> parent, float x, float y, float angle, int count, float pressAngle)
{
	attackParent = parent;
	this->x = x;
	this->y = y;
	setAngle = angle;
	setCount = count;
	setPressAngle = pressAngle;

	action_timecounter = 60;
	setCount--;
	setInterval_count = setInterval_count_max;
}

void CS_Boss_SoapKingMagicFloor_PressWall::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	Entity::Init(self);
}

void CS_Boss_SoapKingMagicFloor_PressWall::Step()
{
	if (setInterval_count > 0)
	{
		setInterval_count--;
		if (setInterval_count == 0)
		{
			//÷
			auto wattackParent = attackParent.lock();
			if (wattackParent)
			{
				auto wfloor = SetCS_Boss_SoapKingMagicFloor(wattackParent, x, y).lock();
				floorArr.push_back(wfloor);
				float dirX, dirY;
				SetPos(setAngle, dirX, dirY);
				x += dirX * (wfloor->cbRect.left + wfloor->cbRect.right);
				y += dirY * (wfloor->cbRect.bottom + wfloor->cbRect.top);
			}
			if (setCount > 0)
			{
				setCount--;
				setInterval_count = setInterval_count_max;
			}
		}
	}
	if (setCount == 0)
	{
		if (action_timecounter > 0)
		{
			action_timecounter--;
			if (action_timecounter == 0)
			{
				float setVx = cosf(setPressAngle * deg2rad) * 4;
				float setVy = sinf(setPressAngle * deg2rad) * 4;
				if (bNormalMode)
				{
					setVx = cosf(setPressAngle * deg2rad) * 2;
					setVy = sinf(setPressAngle * deg2rad) * 2;
				}
				//ǽѹĿ귽
				for (auto& floor : floorArr)
				{
					auto wfloor = floor.lock();
					if (wfloor)
						wfloor->PressToTarget(setVx, setVy);
				}
				Destroy();
			}
		}
	}
}

void CS_Boss_SoapKingMagicFloor_PressWall::SetPos(float angle, float& outX, float& outY)
{
	angle = fmod(angle, 360.0f);
	if (angle < 0)
		angle += 360.0f;
	if (angle > 315 && angle <= 360 || angle >= 0 && angle < 45)
	{
		outX = 1;
		outY = sinf(angle * deg2rad);
	}
	else if (angle == 45)
	{
		outX = 1;
		outY = 1;
	}
	else if (angle > 45 && angle < 135)
	{
		outX = cosf(angle * deg2rad);
		outY = 1;
	}
	else if (angle == 135)
	{
		outX = -1;
		outY = 1;
	}
	else if (angle > 135 && angle < 225)
	{
		outX = -1;
		outY = sinf(angle * deg2rad);
	}
	else if (angle == 225)
	{
		outX = -1;
		outY = -1;
	}
	else if (angle > 225 && angle < 315)
	{
		outX = cosf(angle * deg2rad);
		outY = -1;
	}
	else if (angle == 315)
	{
		outX = 1;
		outY = -1;
	}
}

void SetCS_Boss_SoapKingMagicFloor_PressWall(std::shared_ptr<Entity> parent, float x, float y, float angle, int count, float pressAngle)
{
	auto am = std::make_shared<CS_Boss_SoapKingMagicFloor_PressWall>(parent, x, y, angle, count, pressAngle);
	parent->gameFunc->SetEntity(parent, am);
}
