#include "CS_BlueRobotAni.h"
#include <PeSmog.h>

CS_BlueRobotAni::CS_BlueRobotAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_BlueRobotAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_BlueRobotAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	switch (stateID)
	{
	case 0:
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	}
	if (stateID != 1)
	{
		//
		vx = 0;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_BlueRobotAni::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		this->stateID = stateID;
		//ö
		switch (stateID)
		{
		case 0://վ
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_bluerobot_stand_l" : L"mc_bluerobot_stand_r";
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				ani.sprite_index = lr == 0 ? L"mc_bluerobot_move_l" : L"mc_bluerobot_move_r";
			}
			break;
		}
	}
	else
	{
		switch (stateID)
		{
		case 200://
			cbRect.left = cbRect.right = 5;
			cbRect.top = 4;
			cbRect.bottom = 4;
			ani.sprite_index = this->lr == 0 ? L"mc_robotfish_stand_l" : L"mc_robotfish_stand_r";
			SetPeSmog(shared_from_this(), x, y, 3);
			break;
		case 201://
			cbRect.left = cbRect.right = 5;
			cbRect.top = 6;
			cbRect.bottom = 8;
			this->stateID = 0;
			SetPeSmog(shared_from_this(), x, y, 3);
			break;
		}
	}
}

void CS_BlueRobotAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"transform_fish")
		SetState(200, lr);
	else if (stateName == L"transform_back")
		SetState(201, lr);
}

std::shared_ptr<Entity> CreateCS_BlueRobotAni()
{
	return std::make_shared<CS_BlueRobotAni>();
}
