#include "CS_AmSkeletonProjectile.h"
#include "CS_PeSmoke.h"
#include "CS_PePhoton.h"

CS_AmSkeletonProjectile::CS_AmSkeletonProjectile(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
	hp_max = hp = 1;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_skeleton_projectile";
	//
	speedDir = true;
}

void CS_AmSkeletonProjectile::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		if (lr == 1)
		{
			act_no = 2;
		}
		[[fallthrough]];
	case 1:
		if (cbRect.cbLeft)
		{
			act_no = 2;
			vx = 0x200 / ts;
			++count1;
		}
		if (cbRect.cbRight)
		{
			act_no = 2;
			vx = -0x200 / ts;
			++count1;
		}
		if (cbRect.cbTop)
		{
			act_no = 2;
			vy = 0x200 / ts;
			++count1;
		}
		if (cbRect.cbBottom)
		{
			act_no = 2;
			vy = -0x200 / ts;
			++count1;
		}
		break;
	case 2:
		vy += 0x40 / ts;
		if (cbRect.cbBottom)
		{
			if (++count1 > 1)
			{
				SetCS_PePhoton(shared_from_this(), x, y);
				Destroy();
			}
		}
		break;
	}
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	if (vy < -0x5FF / ts)
		vy = -0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (lr == 0)
	{
		if (++ani_wait > 1)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 3)
			ani_no = 0;
	}
	else
	{
		if (++ani_wait > 1)
		{
			ani_wait = 0;
			--ani_no;
		}
		if (ani_no < 0)
			ani_no = 3;
	}
}

void CS_AmSkeletonProjectile::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 4;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_AmSkeletonProjectile::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		Destroy();
	}
	return true;
}

void SetCS_AmSkeletonProjectile(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmSkeletonProjectile>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
