#include "CS_AmPawcore.h"
#include "CS_AmGaudiProjectile.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include <PeSmog.h>
int g_CS_AmPawcore_style = 0;
CS_AmPawcore::CS_AmPawcore()
{
	type = 2;
	hp_max = hp = 32;
	dropExp = 9;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_pawcore";
	ani.image_index = g_CS_AmPawcore_style % 4;
	g_CS_AmPawcore_style++;
}

void CS_AmPawcore::Step()
{
	if (action_timecounter < 16 && action_timecounter / 2 % 2)
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.erase(1);
	}
	else
	{
		ani.hideLayerList.insert(1);
		ani.hideLayerList.erase(0);
	}
	if (action_timecounter > 0)
	{
		action_timecounter--;
	}
	else
	{
		action_timecounter = 40;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				float dx = wplayer->x - x;
				float dy = wplayer->y - y;
				auto angle = XMConvertToDegrees(XMVectorGetX(XMVector2AngleBetweenVectors(XMVectorSet(1, 0, 0, 0), XMVectorSet(dx, dy, 0, 0))));
				if (dy < 0)
					angle = 360 - angle;
				angle += Random(-6, 6);
				float radian = angle * deg2rad;
				SetCS_AmGaudiProjectile(shared_from_this(), x, y, 3 * cosf(radian), 3 * sinf(radian));
				gameFunc->PlaySound(L"CS_039_em_fire");
			}
		}
	}
	//ִ˶
	Entity::Step();
}

void CS_AmPawcore::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"set_smog")
	{
		SetPeSmog(shared_from_this(), x, y, 1, 1, 90);
	}
}

bool CS_AmPawcore::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 32, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_AmPawcore()
{
	return std::make_shared<CS_AmPawcore>();
}
