#include "CS_AmNightSpirit.h"
#include "CS_PeSmoke.h"

CS_AmNightSpirit::CS_AmNightSpirit(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 6;
	cbRect.bottom = cbRect.top = 3;
	lr = parent->lr;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = lr == 0 ? L"am_nightspirit_l" : L"am_nightspirit_r";
	//
	speedDir = true;
}

void CS_AmNightSpirit::Step()
{
	auto& ani_no = ani.image_index;
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		gameFunc->PlaySound(L"CS_028_shot_hit");
		Destroy();
	}
	vx += (lr == 0 ? -25 / ts : 25 / ts);
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//
	if (++ani_wait > 2)
	{
		ani_wait = 0;
		++ani_no;
	}
	if (ani_no > 2)
		ani_no = 0;
}

void CS_AmNightSpirit::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void CS_AmNightSpirit::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void SetCS_AmNightSpirit(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmNightSpirit>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
