#include "CS_AmLava.h"
#include "CS_PeSmoke.h"
CS_AmLava::CS_AmLava(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 3;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_lava";
	//
	speedDir = true;
}

void CS_AmLava::Step()
{
	vy += 0x20 / ts;
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (cbRect.inWater)
	{
		if (cbRect.inLava)
		{
			Destroy();
			//ҽ
			auto pe = gameFunc->GameCreateEntity(L"pe_spray");
			pe->x = x;
			pe->y = y;
			pe->color = RGBA(0xff, 0, 0, 0xff);
			gameFunc->SetEntity(shared_from_this(), pe);
		}	
		else
		{
			//
			Destroy();
			auto pe = CreateCS_PeSmoke();
			pe->x = x;
			pe->y = y;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
	}
	else if (cbRect.cbBottom)
	{
		//
		Destroy();
		auto pe = CreateCS_PeSmoke();
		pe->x = x;
		pe->y = y;
		gameFunc->SetEntity(shared_from_this(), pe);
	}
}

void CS_AmLava::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void CS_AmLava::Feedback(std::weak_ptr<Entity> target)
{
	//
	Destroy();
	auto pe = CreateCS_PeSmoke();
	pe->x = x;
	pe->y = y;
	gameFunc->SetEntity(shared_from_this(), pe);
}

void SetCS_AmLava(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmLava>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
