#include "CS_AmGaudiArmouredProjectile.h"
#include "CS_PePhoton.h"

CS_AmGaudiArmouredProjectile::CS_AmGaudiArmouredProjectile(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
	hp_max = hp = 1;
	lr = parent->lr;
	//ö
	ani.png = L"CS_CaveStoryMod";
	//
	speedDir = true;
}

void CS_AmGaudiArmouredProjectile::Step()
{
	BOOL bHit;
	switch (act_no)
	{
	case 0:
		[[fallthrough]];
	case 1:
		bHit = FALSE;
		if (cbRect.cbLeft)
		{
			bHit = TRUE;
			vx = 0x200 / ts;
		}
		if (cbRect.cbRight)
		{
			bHit = TRUE;
			vx = -0x200 / ts;
		}
		if (cbRect.cbTop)
		{
			bHit = TRUE;
			vy = 0x200 / ts;
		}
		if (cbRect.cbBottom)
		{
			bHit = TRUE;
			vy = -0x200 / ts;
		}
		if (bHit)
		{
			act_no = 2;
			++count1;
			gameFunc->PlaySound(L"CS_031_shot_bounce");
		}
		break;
	case 2:
		vy += 0x40 / ts;
		if (cbRect.cbBottom)
		{
			if (++count1 > 1)
			{
				SetCS_PePhoton(shared_from_this(), x, y);
				Destroy();
			}
		}
		break;
	}
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	if (vy < -0x5FF / ts)
		vy = -0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//
	ani.sprite_index = lr == 0 ? L"am_gaudi_armoured_l" : L"am_gaudi_armoured_r";
}

void CS_AmGaudiArmouredProjectile::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_AmGaudiArmouredProjectile::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage > 0)
	{
		*outRealDamage = 0;
		return true;
	}
	return false;
}

void CS_AmGaudiArmouredProjectile::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void SetCS_AmGaudiArmouredProjectile(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmGaudiArmouredProjectile>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	am->lr = vx < 0 ? 0 : 1;
	parent->gameFunc->SetEntity(parent, am);
}
