#include "CS_AmFishMissileBase.h"
#include "CS_AmFishMissile.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include <PeSmog.h>
CS_AmFishMissileBase::CS_AmFishMissileBase()
{
	type = 2;
	cbRect.top = 8;
	cbRect.bottom = 24;
	hp_max = hp = 32;
	dropExp = 9;
	//ö
	ani.png = L"CS_CaveStoryMod";
}

void CS_AmFishMissileBase::Step()
{
	if (action_timecounter > 0)
	{
		action_timecounter--;
	}
	else
	{
		action_timecounter = 120;
		if (lr == 0)
			SetCS_AmFishMissile(shared_from_this(), x - 20, y + 16, 3);
		else
			SetCS_AmFishMissile(shared_from_this(), x + 20, y + 16, 2);
	}
	//ִ˶
	Entity::Step();
}

void CS_AmFishMissileBase::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (lr == 0)
	{
		cbRect.left = 24;
		cbRect.right = 8;
	}
	else
	{
		cbRect.left = 8;
		cbRect.right = 24;
	}
	ani.sprite_index = lr == 0 ? L"am_fishmissile_base_l" : L"am_fishmissile_base_r";
}

void CS_AmFishMissileBase::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"set_smog")
	{
		SetPeSmog(shared_from_this(), x, y, 1, 1, 90);
	}
}

bool CS_AmFishMissileBase::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 32, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_AmFishMissileBase()
{
	return std::make_shared<CS_AmFishMissileBase>();
}
