#include "CS_AmBubbleBeam.h"
#include "CS_PeBubbleBeamHit.h"
#include "CS_PeBubbleBeamSpark.h"
#include "CS_PeHurt.h"
CS_AmBubbleBeam::CS_AmBubbleBeam(std::shared_ptr<Entity> parent, int level, void(*RemoveFromAmList)(std::weak_ptr<Entity>, std::weak_ptr<CS_AmBubbleBeam>))
{
	type = 2;
	attackParent = parent;
	this->level = level;
	this->RemoveFromAmList = RemoveFromAmList;
	lr = parent->lr;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
	//ö
	ani.png = L"CS_CaveStoryMod";
	switch (level)
	{
	default:
	case 0:
		ani.sprite_index = L"am_bubblebeam1";
		break;
	case 1:
		ani.sprite_index = L"am_bubblebeam2";
		break;
	case 2:
		ani.sprite_index = L"am_bubblebeam3";
		break;
	}
	//
	speedDir = true;
	action_timecounter = 30;
}

void CS_AmBubbleBeam::Step()
{
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ǽײ
	SetCbRect_Collision();
	//ִײ
	Collision();
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		gameFunc->PlaySound(L"CS_bubblebeam_hit");
		SetCS_PeBubbleBeamHit(shared_from_this(), x, y);
		Destroy();
	}
	//ʧ
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
		{
			SetCS_PeBubbleBeamSpark(shared_from_this(), x, y);
			Destroy();
		}
	}
	//ʵײ
	SetCbRect_Entity();
}

void CS_AmBubbleBeam::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	switch (level)
	{
	default:
	case 0:
		*outDamage = 2;
		break;
	case 1:
		*outDamage = 3;
		break;
	case 2:
		*outDamage = 4;
		break;
	}
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void CS_AmBubbleBeam::Destroy()
{
	auto self = std::static_pointer_cast<CS_AmBubbleBeam>(shared_from_this());
	RemoveFromAmList(attackParent, self);
	Entity::Destroy();
}

void CS_AmBubbleBeam::Feedback(std::weak_ptr<Entity> target)
{
	Destroy();
}

void CS_AmBubbleBeam::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeBubbleBeamHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget->hp > 0)
			SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
	}
}

void CS_AmBubbleBeam::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void CS_AmBubbleBeam::SetCbRect_Entity()
{
	switch (level)
	{
	default:
	case 0:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 5;
		break;
	case 1:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 6;
		break;
	case 2:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 7;
		break;
	}
}

void CS_AmBubbleBeam::SetCbRect_Collision()
{
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 1;
}
