#pragma once
#include "global.h"
#include "MyView.h"
#include "Entity.h"
#include "EntityRes.h"
//Ʋ
struct SlotDrawArg
{
	std::weak_ptr<Entity> player1Icon;
	std::weak_ptr<Entity> player2Icon;
	std::wstring name;
};
struct SlotMycharData
{
	std::wstring png;
	std::wstring spriteIndex;
	int imageIndex = 0;
	std::set<int> hideLayerList;
	int HpMax = 0;
	int Hp = 0;
	int MpMax = 0;
	int Mp = 0;
	std::wstring uiName;
	int SkillArr[6];
	std::vector<int> throwItem;
};
//Ĵ浵
struct LoadedSlot
{
	SlotMycharData player1;
	SlotMycharData player2;
	bool loadFail = true;
};
//浵
class SlotDrawer
{
public:
	void Init(MyDX11Renderer* pRenderer, MyView* pView, EntityRes* pEntityRes);
	void Reset();
	void Draw();
	void EnableDraw(bool bEnable);
	void AddDraw(std::weak_ptr<Entity> player1Icon, std::weak_ptr<Entity> player2Icon, const wchar_t* name);
	void DrawClear();
private:
	MyDX11Renderer* pRenderer = nullptr;
	MyView* pView = nullptr;
	EntityRes* pEntityRes = nullptr;
	std::list<SlotDrawArg> drawList;
	std::unordered_map<std::wstring, LoadedSlot> loadedSlot;
	bool enbaleDraw = false;
	void DrawSlot(std::weak_ptr<Entity> player1Icon, std::weak_ptr<Entity> player2Icon, const LoadedSlot* slot);
	LoadedSlot LoadSaveFileToSlot(const wchar_t* name);
};

