#include "MiniScriptSystem.h"
#include "main.h"

void MiniScriptSystem::Init(const MyGame* otherGame)
{
	this->otherGame = otherGame;
	this->pRenderer = otherGame->pRenderer;
	this->pInput = otherGame->pInput;
	this->pJoystickInput = otherGame->pJoystickInput;
	this->pView = otherGame->pView;
	int* pMapW = nullptr;
	int* pMapH = nullptr;
	gameMap.GetMapSize(&pMapW, &pMapH);
	//ʼGameFunc
	gameFunc = otherGame->gameFunc;
	gameFunc.entityRes = &entityRes;
	gameFunc.gameMap = &gameMap;
	gameFunc.dmgNum = &dmgNum;
	gameFunc.gameScript = &gameScript;
	gameFunc.gameUI = &gameUI;
	gameFunc.flagSet = &flagSet;
	gameFunc.game = this;
	//ʼ
	gameMap.Init(pView, &gamePxa, &scriptCmd);
	myCamera.Init(pView, pMapW, pMapH);
	entityRes.Init(pRenderer, pInput, pView, pMapW, pMapH, &gamePid, &gameFunc,
		&mychar_player1, &mychar_player1_menuKeyboard, &mychar_player2, &mychar_player2_menuKeyboard,
		&checkEventPlayerIndex, &globalEntity);
	gameScript.Init(this);
	scriptCmd.Init(this);
	gameMsgbox.Init(pRenderer, pView, &gameScript, &mychar_player1, &mychar_player2);
	gameFade.Init(pRenderer, pView, &mychar_player1);
	gameUI.Init(pRenderer, pView, &entityRes);
	dmgNum.Init(pRenderer, pView);
	mapSystem.Init(pRenderer, pView, &gameMap, &gamePxa, &mychar_player1, &mychar_player2, this);
	stageDrawer.Init(pRenderer, pView, &gameMap, &entityRes, &gamePxa);
	LoadSetting(L"SysNull");
	//
	GetKey[0] = &GameInput::GetUp;
	GetKey[1] = &GameInput::GetDown;
	GetKey[2] = &GameInput::GetLeft;
	GetKey[3] = &GameInput::GetRight;
	GetKey[4] = &GameInput::GetOk;
	GetKey[5] = &GameInput::GetCancel;
	GetKey[6] = &GameInput::GetJump;
	GetKey[7] = &GameInput::GetAtk;
	GetKey[8] = &GameInput::GetMenu;
	GetKey[9] = &GameInput::GetInventory;
	GetKey[10] = &GameInput::GetMap;
	GetKey[11] = &GameInput::GetPagePrev;
	GetKey[12] = &GameInput::GetPageNext;
	GetKey[13] = &GameInput::GetSwitchMc;
	GetKey[14] = &GameInput::GetSkill_1;
	GetKey[15] = &GameInput::GetSkill_2;
	GetKey[16] = &GameInput::GetSkill_3;
	GetKey[17] = &GameInput::GetSkill_4;
	GetKey[18] = &GameInput::GetSkill_5;
	GetKey[19] = &GameInput::GetSkill_6;

	SetKey[0] = &GameInput::SetUp;
	SetKey[1] = &GameInput::SetDown;
	SetKey[2] = &GameInput::SetLeft;
	SetKey[3] = &GameInput::SetRight;
	SetKey[4] = &GameInput::SetOk;
	SetKey[5] = &GameInput::SetCancel;
	SetKey[6] = &GameInput::SetJump;
	SetKey[7] = &GameInput::SetAtk;
	SetKey[8] = &GameInput::SetMenu;
	SetKey[9] = &GameInput::SetInventory;
	SetKey[10] = &GameInput::SetMap;
	SetKey[11] = &GameInput::SetPagePrev;
	SetKey[12] = &GameInput::SetPageNext;
	SetKey[13] = &GameInput::SetSwitchMc;
	SetKey[14] = &GameInput::SetSkill_1;
	SetKey[15] = &GameInput::SetSkill_2;
	SetKey[16] = &GameInput::SetSkill_3;
	SetKey[17] = &GameInput::SetSkill_4;
	SetKey[18] = &GameInput::SetSkill_5;
	SetKey[19] = &GameInput::SetSkill_6;

	//1Keyboard
	is_p1k[0] = &inputSetting_player1Keyboard.op_up;
	is_p1k[1] = &inputSetting_player1Keyboard.op_down;
	is_p1k[2] = &inputSetting_player1Keyboard.op_left;
	is_p1k[3] = &inputSetting_player1Keyboard.op_right;
	is_p1k[4] = &inputSetting_player1Keyboard.op_ok;
	is_p1k[5] = &inputSetting_player1Keyboard.op_cancel;
	is_p1k[6] = &inputSetting_player1Keyboard.op_jump;
	is_p1k[7] = &inputSetting_player1Keyboard.op_atk;
	is_p1k[8] = &inputSetting_player1Keyboard.op_menu;
	is_p1k[9] = &inputSetting_player1Keyboard.op_inventory;
	is_p1k[10] = &inputSetting_player1Keyboard.op_map;
	is_p1k[11] = &inputSetting_player1Keyboard.op_pagePrev;
	is_p1k[12] = &inputSetting_player1Keyboard.op_pageNext;
	is_p1k[13] = &inputSetting_player1Keyboard.op_switchMc;
	is_p1k[14] = &inputSetting_player1Keyboard.op_skill_1;
	is_p1k[15] = &inputSetting_player1Keyboard.op_skill_2;
	is_p1k[16] = &inputSetting_player1Keyboard.op_skill_3;
	is_p1k[17] = &inputSetting_player1Keyboard.op_skill_4;
	is_p1k[18] = &inputSetting_player1Keyboard.op_skill_5;
	is_p1k[19] = &inputSetting_player1Keyboard.op_skill_6;

	//2Keyboard
	is_p2k[0] = &inputSetting_player2Keyboard.op_up;
	is_p2k[1] = &inputSetting_player2Keyboard.op_down;
	is_p2k[2] = &inputSetting_player2Keyboard.op_left;
	is_p2k[3] = &inputSetting_player2Keyboard.op_right;
	is_p2k[4] = &inputSetting_player2Keyboard.op_ok;
	is_p2k[5] = &inputSetting_player2Keyboard.op_cancel;
	is_p2k[6] = &inputSetting_player2Keyboard.op_jump;
	is_p2k[7] = &inputSetting_player2Keyboard.op_atk;
	is_p2k[8] = &inputSetting_player2Keyboard.op_menu;
	is_p2k[9] = &inputSetting_player2Keyboard.op_inventory;
	is_p2k[10] = &inputSetting_player2Keyboard.op_map;
	is_p2k[11] = &inputSetting_player2Keyboard.op_pagePrev;
	is_p2k[12] = &inputSetting_player2Keyboard.op_pageNext;
	is_p2k[13] = &inputSetting_player2Keyboard.op_switchMc;
	is_p2k[14] = &inputSetting_player2Keyboard.op_skill_1;
	is_p2k[15] = &inputSetting_player2Keyboard.op_skill_2;
	is_p2k[16] = &inputSetting_player2Keyboard.op_skill_3;
	is_p2k[17] = &inputSetting_player2Keyboard.op_skill_4;
	is_p2k[18] = &inputSetting_player2Keyboard.op_skill_5;
	is_p2k[19] = &inputSetting_player2Keyboard.op_skill_6;

	//1Joystick
	is_p1j[0] = &inputSetting_player1Joystick.op_up;
	is_p1j[1] = &inputSetting_player1Joystick.op_down;
	is_p1j[2] = &inputSetting_player1Joystick.op_left;
	is_p1j[3] = &inputSetting_player1Joystick.op_right;
	is_p1j[4] = &inputSetting_player1Joystick.op_ok;
	is_p1j[5] = &inputSetting_player1Joystick.op_cancel;
	is_p1j[6] = &inputSetting_player1Joystick.op_jump;
	is_p1j[7] = &inputSetting_player1Joystick.op_atk;
	is_p1j[8] = &inputSetting_player1Joystick.op_menu;
	is_p1j[9] = &inputSetting_player1Joystick.op_inventory;
	is_p1j[10] = &inputSetting_player1Joystick.op_map;
	is_p1j[11] = &inputSetting_player1Joystick.op_pagePrev;
	is_p1j[12] = &inputSetting_player1Joystick.op_pageNext;
	is_p1j[13] = &inputSetting_player1Joystick.op_switchMc;
	is_p1j[14] = &inputSetting_player1Joystick.op_skill_1;
	is_p1j[15] = &inputSetting_player1Joystick.op_skill_2;
	is_p1j[16] = &inputSetting_player1Joystick.op_skill_3;
	is_p1j[17] = &inputSetting_player1Joystick.op_skill_4;
	is_p1j[18] = &inputSetting_player1Joystick.op_skill_5;
	is_p1j[19] = &inputSetting_player1Joystick.op_skill_6;

	//1Joystick
	is_p2j[0] = &inputSetting_player2Joystick.op_up;
	is_p2j[1] = &inputSetting_player2Joystick.op_down;
	is_p2j[2] = &inputSetting_player2Joystick.op_left;
	is_p2j[3] = &inputSetting_player2Joystick.op_right;
	is_p2j[4] = &inputSetting_player2Joystick.op_ok;
	is_p2j[5] = &inputSetting_player2Joystick.op_cancel;
	is_p2j[6] = &inputSetting_player2Joystick.op_jump;
	is_p2j[7] = &inputSetting_player2Joystick.op_atk;
	is_p2j[8] = &inputSetting_player2Joystick.op_menu;
	is_p2j[9] = &inputSetting_player2Joystick.op_inventory;
	is_p2j[10] = &inputSetting_player2Joystick.op_map;
	is_p2j[11] = &inputSetting_player2Joystick.op_pagePrev;
	is_p2j[12] = &inputSetting_player2Joystick.op_pageNext;
	is_p2j[13] = &inputSetting_player2Joystick.op_switchMc;
	is_p2j[14] = &inputSetting_player2Joystick.op_skill_1;
	is_p2j[15] = &inputSetting_player2Joystick.op_skill_2;
	is_p2j[16] = &inputSetting_player2Joystick.op_skill_3;
	is_p2j[17] = &inputSetting_player2Joystick.op_skill_4;
	is_p2j[18] = &inputSetting_player2Joystick.op_skill_5;
	is_p2j[19] = &inputSetting_player2Joystick.op_skill_6;
}

void MiniScriptSystem::SetMode(int msgBoxSideMode, int playerIndex)
{
	gameMsgbox.SetSideMode(msgBoxSideMode);
	//ģʽ
	if (msgBoxSideMode == 0)
		gameScript.EachNOD(false, 0);
	//
	else
		gameScript.EachNOD(true, playerIndex);
}

void MiniScriptSystem::Draw(float deltaTime)
{
	//ı
	gameMsgbox.Draw(deltaTime);
}

void MiniScriptSystem::Step()
{
	//ҵ
	//if (mychar_player1)
	//{
	//	//otherGame->mychar_player1->input.key = mychar_player1->input.key;
	//	otherGame->mychar_player1->inputLock.key |= mychar_player1->inputLock.key;
	//}
	//if (mychar_player2)
	//{
	//	//otherGame->mychar_player2->input.key = mychar_player2->input.key;
	//	otherGame->mychar_player2->inputLock.key |= mychar_player2->inputLock.key;
	//}
	//ִнű
	gameScript.Step();
	//ִı
	gameMsgbox.Step();
}

void MiniScriptSystem::Reset()
{
	gameScript.Reset();
}

void MiniScriptSystem::SaveGame(std::vector<char>* saveData)
{
}

void MiniScriptSystem::LoadGame(const char* loadData)
{
}

void MiniScriptSystem::OnResetScale(int w, int h)
{
	gameMsgbox.OnResetScale();
}
