#pragma once
#include "global.h"
#include "MyView.h"
#include "GameMsgbox.h"
#include "GameScript.h"
#include "MapSystem.h"
#include "Entity.h"
#include "EntityRes.h"
#include "GameUI.h"
class MiniScriptSystem;
//ƷעϢ
struct ItemRegister
{
	std::wstring iconEntityName;//ͼʵ
	std::wstring fName;//ѡʱõlua
	std::wstring checkFName;//ʱõlua
	bool stackable = false;//ɵƷ
};
//Ʒ
struct ItemData
{
	std::wstring regID;//ƷעϢ
	std::weak_ptr<Entity> e;//ʵָ
	int num = 1;//ӵ
	bool locked = false;//ƷǷ״̬
};
//עϢ
struct MissionRegister
{
	std::wstring iconEntityName;//ͼʵ
	std::wstring name;//
	std::wstring fName;//ѡʱõlua
	std::wstring checkFName;//ʱõlua
};
//
struct MissionData
{
	std::wstring regID;//עϢ
	std::weak_ptr<Entity> e;//ʵָ
};
//Ʒϵͳ
class ItemSystem
{
public:
	virtual ~ItemSystem();
	void Init(MyDX11Renderer* pRenderer, MyView* pView, MySDLInput* pSDLInput, GameMsgbox* pGameMsgBox,
		GameScript* pGameScript, MapSystem* pMapSystem, EntityRes* pEntityRes, GameUI* pGameUI, const void* game);
	void Reset();
	bool GetShow();
	void Step();
	void Draw(float deltaTime);
	void OnResetScale(int w, int h);
	void SetEnable(bool bEnable);
	bool IsPanelFree(GameScript* gameScript);
	bool IsItemSystemFree();//ƷϵͳǷڿ״̬
	void RegisterItem(const wchar_t* regID, ItemRegister itemReg);
	int AddItem(const wchar_t* regID, int num);
	int FindItem(const wchar_t* regID);
	void LockItem(int itemIndex, bool bLock);//һƷ޷
	bool ItemLocked(int itemIndex);//鿴һƷǷ
	std::vector<ItemData>* GetItemList();
	void RegisterMission(const wchar_t* regID, MissionRegister missionReg);
	void AddMission(const wchar_t* regID);
	void DeleteMission(const wchar_t* regID);
	void DeleteAllMission();
	void ReplaceMission(const wchar_t* regID_src, const wchar_t* regID_dst);
	std::list<MissionData>::iterator FindMission(const wchar_t* regID);
	std::list<MissionData>* GetMissionList();
	void Controll();
	void SetShowMiniItem(bool bShowMiniItem, const wchar_t* regID, int num);//ʾƷ
	void LockAllPlayerJump();//ֹԾ
	bool IsEnableMapSystem();//Ƿõͼϵͳ
	void ReloadLanguage();
private:
	MyDX11Renderer* pRenderer = nullptr;
	MyView* pView = nullptr;
	MySDLInput* pSDLInput = nullptr;
	GameMsgbox* pGameMsgBox = nullptr;
	GameScript* pGameScript = nullptr;
	MapSystem* pMapSystem = nullptr;
	EntityRes* pEntityRes = nullptr;
	GameUI* pGameUI = nullptr;
	float itemsys_x = 0, itemsys_y = 0;
	const int itemsys_page_count_w = 20;
	const int itemsys_page_count_h = 22;
	bool bShow = false;
	bool bShowMiniItem = false;//ʾСƷ
	int pageIndex = 0;
	bool bEnable = false;
	const int cursor_flash_interval = 16;
	int cursor_flash_interval_counter = 0;
	bool cursor_flash = false;
	bool enableMapSystem = false;
	void DrawFrame();//Ʒ
	void DrawAddItemPage();
	void DrawAddMissionPage();
	bool PageControl();
	void ForceEndScript(GameScript* gameScript, GameMsgbox* gameMsgBox);
	//Ʒб
	int itemCursor_x_player1 = 0;//Ʒ
	int itemCursor_y_player1 = 0;
	int itemCursor_x_selected_player1 = -1;//Ʒѡй
	int itemCursor_y_selected_player1 = -1;
	int itemCursor_x_player2 = 0;//Ʒ
	int itemCursor_y_player2 = 0;
	int itemCursor_x_selected_player2 = -1;//Ʒѡй
	int itemCursor_y_selected_player2 = -1;
	int SkillCursorToItemCursorX(int playerIndex) const;
	int ItemCursorXToSkillCursor(int playerIndex) const;
	//
	int skillCursor_player1 = -1;//
	int skillCursor_selected_player1 = -1;//
	int skillCursor_player2 = -1;//
	int skillCursor_selected_player2 = -1;//
	int itemCursorMode_player1 = 0;//0Ʒ 1Ƽ
	int itemCursorMode_player2 = 0;//0Ʒ 1Ƽ
	std::map<std::wstring, ItemRegister> itemRegList;
	std::vector<ItemData> itemList;
	void DrawItem();
	void DrawAddCursor();//ƹ
	void ItemMenuControl(GameScript* gameScript, GameMsgbox* gameMsgBox, std::weak_ptr<Entity> player,
		int* pCursorX, int* pCursorY, int* pCursorX_selected, int* pCursorY_selected, int* pSkillCursor, int* pSkillCursor_selected, int* pItemCursorMode);
	void ItemMenuUpdate(GameScript* gameScript, GameMsgbox* gameMsgBox, int cursorX, int cursorY, bool bCheck = false);
	void ItemMenuScript(GameScript* gameScript, GameMsgbox* gameMsgBox, int cursorX, int cursorY);
	void SkillMenuUpdate(GameScript* gameScript, GameMsgbox* gameMsgBox, PlayerUIData* ui, int skillCursor, bool bCheck = false);
	void SkillMenuScript(GameScript* gameScript, GameMsgbox* gameMsgBox, PlayerUIData* ui, int skillCursor);
	void ResetCursorPos();
	//·ҳı
	void DrawPanelFreeGraph();
	//б
	int missionCursor_player1 = 0;//
	int missionCursor_player2 = 0;//
	TTF_Font* myfont12 = nullptr;
	std::unordered_map<wchar_t, MyFontData> fontMap_myfont12;
	std::unordered_map<std::wstring, MissionRegister> missionRegList;
	std::list<MissionData> missionList;
	void DrawMission();
	void MissionMenuControl(GameScript* gameScript, GameMsgbox* gameMsgBox, std::weak_ptr<Entity> player, int* pMissionCursor);
	void MissionMenuUpdate(GameScript* gameScript, GameMsgbox* gameMsgBox, int missionCursor, bool bCheck = false);
	void MissionMenuScript(GameScript* gameScript, GameMsgbox* gameMsgBox, int missionCursor);
	//
	void DrawPanel_Player1(float offx, float offy);//1
	void DrawPanel_Player2(float offx, float offy);//2
	void DrawAddEntity(std::shared_ptr<Entity>& we, float offx, float offy);
	void DrawAddEntity2(std::shared_ptr<Entity>& we, float offx, float offy);
	void DrawAddNum(float srcX, float srcY, float dstX, float dstY, int num, bool order = false);
	MiniScriptSystem* childScriptSys_player1 = nullptr;
	MiniScriptSystem* childScriptSys_player2 = nullptr;
	//ͼʵ
	std::list<std::shared_ptr<Entity>> itemIconEntity;//Ʒʵ
	void DrawAddEntity_Icon(std::shared_ptr<Entity>& we, float offx, float offy);//ͼʵ
	void DrawAddEntity2_Icon(std::shared_ptr<Entity>& we, float offx, float offy);//ͼʵ
	void DrawAddItemIconEntity();
	//Ʒ
	ItemData miniItem;
	std::list<std::shared_ptr<Entity>> miniItemEntity;//Ʒʵ
	void DrawMiniItem();
	//ʵ
	std::list<std::shared_ptr<Entity>> missionIconEntity;
	void DrawAddMissionIconEntity();
};

