#include "GameMap.h"
#include "MyView.h"
#include "GamePxa.h"
#include "ScriptLuaFunc.h"
#include "main.h"
#include "TranslateLua.h"
extern HWND hwnd;
GameMap::~GameMap()
{
	if (scriptL)
		lua_close(scriptL);
}

void GameMap::Init(MyView* pView, GamePxa* pGamePxa, void* pScriptCmd)
{
	this->pView = pView;
	this->pGamePxa = pGamePxa;
	this->scriptCmd = pScriptCmd;
}
//main.cpp
void GameMap::GetMapSize(int** ppMapW, int** ppMapH)
{
	*ppMapW = &mapW;
	*ppMapH = &mapH;
}

std::wstring GameMap::GetMapFileName()
{
	return mapfileName;
}

std::list<MyMapLayer>* GameMap::GetLayerList()
{
	return &layerList;
}

MyMapLayer* GameMap::GetMapLayer(const wchar_t* layerName)
{
	auto iter = queryMapLayer.find(layerName);
	if (iter != queryMapLayer.end())
		return iter->second;
	else
		return nullptr;
}

lua_State** GameMap::GetScriptLPtr()
{
	return &scriptL;
}

MyView* GameMap::GetView()
{
	return pView;
}

void GameMap::LoadMap(const wchar_t* mapfileName)
{
	this->mapfileName = mapfileName;
	wchar_t wbuff[MAX_PATH];
	std::vector<char> gbk;
	std::vector<wchar_t> utf16;
	//ͼ
	swprintf_s(wbuff, L"./data/map/%s.pxm", mapfileName);
	FILE* fp;
	_wfopen_s(&fp, wbuff, L"rb");
	if (!fp)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ͼļ%s޷ʧ", wbuff);
		MessageBoxW(hwnd, err, L"Դ", MB_ICONERROR);
		return;
	}
	fseek(fp, 0, SEEK_END);
	size_t fileLen = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	std::vector<BYTE> file_buff;
	file_buff.resize(fileLen);
	fread_s(file_buff.data(), file_buff.size(), fileLen, 1, fp);
	fclose(fp);
	std::vector<BYTE> byte_buff;
	size_t len = 0;
	ZLibUncompressData(&byte_buff, &len, file_buff.data(), fileLen);
	LoadMapXML((const wchar_t*)byte_buff.data());
	pView->count_w = mapW;
	pView->count_max = pView->count_w * mapH;
	if (!scriptCmd)
		return;
	//ͼű
	if (scriptL)
		lua_close(scriptL);
	scriptL = NewScriptL(scriptCmd);
	//дһ·
	luaL_dostring(scriptL, "global_path=\"./data/\"");
	//ȫֽű
	if (luaL_dofile(scriptL, "./data/global.lua") != LUA_OK)
	{
		auto err = lua_tostring(scriptL, -1);
		GBKToUTF16(err, &utf16);
		MessageBox(hwnd, utf16.data(), L"globalű", MB_ICONWARNING);
		lua_pop(scriptL, 1);
	}
	//ͼű
	swprintf_s(wbuff, L"./data/map/%s.lua", mapfileName);
	UTF16ToGBK(wbuff, &gbk);
	if (luaL_dofile(scriptL, gbk.data()) != LUA_OK)
	{
		auto err = lua_tostring(scriptL, -1);
		GBKToUTF16(err, &utf16);
		wchar_t title[MAX_PATH];
		swprintf_s(title, L"%sű", wbuff);
		MessageBox(hwnd, utf16.data(), title, MB_ICONWARNING);
		lua_pop(scriptL, 1);
	}
	ReloadLanguage();
}

void GameMap::LoadMapXML(const wchar_t* xml)
{
	std::vector<char> xml_gbk;
	UTF16ToGBK(xml, &xml_gbk);
	tinyxml2::XMLDocument xmlDoc;
	xmlDoc.Parse(xml_gbk.data());
	tinyxml2::XMLElement* elem = nullptr;
	//ѰPxmԪ
	for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
	{
		if (!strcmp(pElem->Name(), "Pxm"))
		{
			elem = pElem;
			break;
		}	
	}
	if (!elem)
	{
		MessageBoxW(hwnd, L"ͼXMLļҲPxmԪ", L"Դ", MB_ICONERROR);
		return;
	}
	//ȡͼ
	std::priority_queue<MyMapLayer> sortList;
	std::vector<wchar_t> wchar_buff;
	GBKToUTF16(elem->Attribute("MapName"), &wchar_buff);
	mapName = wchar_buff.data();
	mapW = elem->IntAttribute("MapW");
	mapH = elem->IntAttribute("MapH");
	//LayerԪ
	for (auto p = elem->FirstChildElement(); p; p = p->NextSiblingElement())
	{
		//LayerԪ
		if (strcmp(p->Name(), "Layer"))
			continue;
		MyMapLayer layer;
		//ͼ
		GBKToUTF16(p->Attribute("Name"), &wchar_buff);//ȡͼ
		layer.layerName = wchar_buff.data();
		//ͼɼ
		layer.visible = p->BoolAttribute("Visiable");
		//
		GBKToUTF16(p->Attribute("PxaName"), &wchar_buff);//ȡ
		layer.pxaName = wchar_buff.data();
		//ͼ
		layer.layerType = p->IntAttribute("LayerType");
		//ͼ
		layer.offx = p->FloatAttribute("OffX");//xƫ
		layer.offy = p->FloatAttribute("OffY");//yƫ
		layer.myFar = p->FloatAttribute("Far");//
		//ѭ
		layer.loopH = p->BoolAttribute("LoopH");//ˮƽѭʾ
		layer.loopV = p->BoolAttribute("LoopV");//ֱѭʾ
		layer.speedH = p->FloatAttribute("SpeedH");//ˮƽƽٶ
		layer.speedV = p->FloatAttribute("SpeedV");//ֱƽٶ
		//ͨ
		layer.order = p->FloatAttribute("Order");//ͼ˳
		layer.jumpFrame_counter = layer.jumpFrame = p->IntAttribute("JumpFrame");
		//
		layer.dayLight = p->FloatAttribute("DayLight", 1.0f);//
		layer.tinyHSV[0] = p->FloatAttribute("tinyHSV_H", 0.0f);//ϸ΢HSV
		layer.tinyHSV[1] = p->FloatAttribute("tinyHSV_S", 0.0f);//ϸ΢HSV
		layer.tinyHSV[2] = p->FloatAttribute("tinyHSV_V", 0.0f);//ϸ΢HSV
		layer.lightConst = p->FloatAttribute("LightConst", 1.0f);//յĹӰ
		//ɫ
		layer.color = (DWORD)p->Unsigned64Attribute("Color");//ɫ
		//Ƽ
		layer.enableClipZone = p->BoolAttribute("EnableClipZone");//ûƼ
		layer.clipZone.top = p->FloatAttribute("ClipUp");//
		layer.clipZone.bottom = p->FloatAttribute("ClipDown");//
		layer.clipZone.left = p->FloatAttribute("ClipLeft");//
		layer.clipZone.right = p->FloatAttribute("ClipRight");//
		auto& step_pxm = layer.step_pxm;
		auto& step_pxe = layer.step_pxe;
		//IDԪ
		for (auto t = p->FirstChildElement(); t != nullptr; t = t->NextSiblingElement())
		{
			//RectԪ
			if (!strcmp(t->Name(), "ID"))
			{
				int pxmX = t->IntAttribute("pxmX");
				int pxmY = t->IntAttribute("pxmY");
				int pxaX = t->IntAttribute("pxaX");
				int pxaY = t->IntAttribute("pxaY");
				step_pxm.insert(std::make_pair(MAKELONG(pxmX, pxmY), MAKELONG(pxaX, pxaY)));
			}
			//ENTԪ
			else if (!strcmp(t->Name(), "ENT"))
			{
				EntityLoad entityLoad;
				GBKToUTF16(t->Attribute("name"), &wchar_buff);
				entityLoad.name = wchar_buff.data();
				entityLoad.x = t->IntAttribute("x");
				entityLoad.y = t->IntAttribute("y");
				GBKToUTF16(t->Attribute("eid"), &wchar_buff);
				entityLoad.eid = wchar_buff.data();
				GBKToUTF16(t->Attribute("event"), &wchar_buff);
				entityLoad.eventName = wchar_buff.data();
				wchar_buff.resize(1);
				wchar_buff[0] = 0;
				GBKToUTF16(t->Attribute("arg"), &wchar_buff);
				entityLoad.arg = wchar_buff.data();
				wchar_buff.resize(1);
				wchar_buff[0] = 0;
				GBKToUTF16(t->Attribute("arg2"), &wchar_buff);
				entityLoad.arg2 = wchar_buff.data();
				wchar_buff.resize(1);
				wchar_buff[0] = 0;
				GBKToUTF16(t->Attribute("arg3"), &wchar_buff);
				entityLoad.arg3 = wchar_buff.data();
				auto& flag = entityLoad.flag;
				flag.tCheck = t->BoolAttribute("tCheck");
				flag.tTouch = t->BoolAttribute("tTouch");
				flag.tDeath = t->BoolAttribute("tDeath");
				flag.tCrush = t->BoolAttribute("tCrush");
				flag.tHurt = t->BoolAttribute("tHurt");
				flag.tDamage = t->BoolAttribute("tDamage");
				flag.fShow = t->BoolAttribute("fShow");
				flag.fHide = t->BoolAttribute("fHide");
				flag.skShow = t->BoolAttribute("skShow");
				flag.skHide = t->BoolAttribute("skHide");
				flag.lr = t->BoolAttribute("lr");
				flag.text = t->BoolAttribute("text");
				flag.save = t->BoolAttribute("save");
				flag.simpAni = t->BoolAttribute("simpAni");
				step_pxe.push_back(entityLoad);
			}
		}
		//µİ汾
		auto& PxaData = *pGamePxa->GetPxa(layer.pxaName.c_str());
		layer.UpdatePxmArr(PxaData.pxaArr_w);
		sortList.push(layer);
	}
	//
	layerList.clear();
	while (!sortList.empty())
	{
		layerList.push_front(sortList.top());
		sortList.pop();
	}
	queryMapLayer.clear();
	for (auto& p : layerList)
		queryMapLayer.insert(std::make_pair(p.layerName, &p));
}

const wchar_t* GameMap::GetMapShowName()
{
	auto iter = roomNameTable.find(mapName);
	if (iter != roomNameTable.end())
		return iter->second.c_str();
	return mapName.c_str();
}

void GameMap::ReloadLanguage()
{
	if (!scriptL)
		return;
	std::vector<char> gbk;
	std::vector<wchar_t> utf16;
	char buff[MAX_PATH];
	wchar_t wbuff[MAX_PATH];
	//뷭ĽűļУ
	if (language_now.length() > 0)
	{
		FILE* fp = nullptr;
		//뷭ȫֽű
		swprintf_s(wbuff, L"./data/language/%s/global.lua", language_now.c_str());
		_wfopen_s(&fp, wbuff, L"rb");
		if (fp)
		{
			fclose(fp);
			//дglobal·ȫֱ
			UTF16ToGBK(language_now.c_str(), &gbk);
			sprintf_s(buff, "global_path=\"./data/language/%s/\"", gbk.data());
			luaL_dostring(scriptL, buff);
			//ļڣ
			UTF16ToGBK(wbuff, &gbk);
			if (luaL_dofile(scriptL, gbk.data()) != LUA_OK)
			{
				auto err = lua_tostring(scriptL, -1);
				wchar_t errBuff[MAX_PATH];
				swprintf_s(errBuff, L"%sglobalű", language_now.c_str());
				GBKToUTF16(err, &utf16);
				MessageBox(hwnd, utf16.data(), errBuff, MB_ICONWARNING);
				lua_pop(scriptL, 1);
			}
		}
		//Ӧķű
		swprintf_s(wbuff, L"./data/language/%s/script/%s.lua", language_now.c_str(), mapfileName.c_str());
		_wfopen_s(&fp, wbuff, L"rb");
		if (fp)
		{
			fclose(fp);
			//ļڣ
			UTF16ToGBK(wbuff, &gbk);
			if (luaL_dofile(scriptL, gbk.data()) != LUA_OK)
			{
				auto err = lua_tostring(scriptL, -1);
				GBKToUTF16(err, &utf16);
				wchar_t title[MAX_PATH];
				swprintf_s(title, L"%sű", wbuff);
				MessageBox(hwnd, utf16.data(), title, MB_ICONWARNING);
				lua_pop(scriptL, 1);
			}
		}
		//뷭ķ
		roomNameTable.clear();
		//Ѱļ
		swprintf_s(wbuff, L"./data/language/%s/roomName.lua", language_now.c_str());
		_wfopen_s(&fp, wbuff, L"rb");
		if (fp)
		{
			fclose(fp);
			//ļڣ
			UTF16ToGBK(wbuff, &gbk);
			auto L = NewTranslateLua();
			if (luaL_dofile(L, gbk.data()) != LUA_OK)
			{
				auto err = lua_tostring(L, -1);
				GBKToUTF16(err, &utf16);
				wchar_t title[MAX_PATH];
				swprintf_s(title, L"%sű", wbuff);
				MessageBox(hwnd, utf16.data(), title, MB_ICONWARNING);
				lua_pop(L, 1);
			}
			lua_close(L);
		}
	}
}

void GameMap::CMP(std::wstring layerNameCopyFrom, std::wstring layerNameCopyTo, std::vector<LONG>* pPosArr)
{
	MyMapLayer* layerCopyFrom = nullptr;
	MyMapLayer* layerCopyTo = nullptr;
	if (pPosArr)
		pPosArr->clear();
	for (auto& p : layerList)
	{
		if (p.layerName == layerNameCopyFrom)
			layerCopyFrom = &p;
		else if (p.layerName == layerNameCopyTo)
			layerCopyTo = &p;
		if (layerCopyFrom && layerCopyTo)
			break;
	}
	if (!(layerCopyFrom && layerCopyTo))
		return;
	int pxaArr_w = pGamePxa->GetPxa(layerCopyTo->pxaName.c_str())->pxaArr_w;
	for (auto& p : layerCopyFrom->step_pxm)
	{
		if (p.second == 0)
			continue;
		layerCopyTo->step_pxm[p.first] = p.second;
		layerCopyTo->UpdatePxmArr(pxaArr_w);
		if (pPosArr)
			pPosArr->push_back(p.first);
	}
}

void GameMap::FullLight()
{
	for (auto& p : layerList)
		p.dayLight = 1;
}

void GameMap::ReloadGameMapScript()
{
	if (mapfileName.length() == 0)
		return;
	wchar_t wbuff[MAX_PATH];
	std::vector<char> gbk;
	std::vector<wchar_t> utf16;
	//ͼ
	swprintf_s(wbuff, L"./data/map/%s.pxm", mapfileName.c_str());
	FILE* fp;
	_wfopen_s(&fp, wbuff, L"rb");
	if (!fp)
	{
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"ͼļ%s޷ʧ", wbuff);
		MessageBoxW(hwnd, err, L"Դ", MB_ICONERROR);
		return;
	}
	fseek(fp, 0, SEEK_END);
	size_t fileLen = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	std::vector<BYTE> file_buff;
	file_buff.resize(fileLen);
	fread_s(file_buff.data(), file_buff.size(), fileLen, 1, fp);
	fclose(fp);
	std::vector<BYTE> byte_buff;
	size_t len = 0;
	ZLibUncompressData(&byte_buff, &len, file_buff.data(), fileLen);
	LoadMapXML((const wchar_t*)byte_buff.data());
	//ͼű
	if (scriptL)
		lua_close(scriptL);
	scriptL = NewScriptL(scriptCmd);
	//дһ·
	luaL_dostring(scriptL, "global_path=\"./data/\"");
	//ȫֽű
	if (luaL_dofile(scriptL, "./data/global.lua") != LUA_OK)
	{
		auto err = lua_tostring(scriptL, -1);
		GBKToUTF16(err, &utf16);
		MessageBox(hwnd, utf16.data(), L"globalű", MB_ICONWARNING);
		lua_pop(scriptL, 1);
	}
	//ͼű
	swprintf_s(wbuff, L"./data/map/%s.lua", mapfileName.c_str());
	UTF16ToGBK(wbuff, &gbk);
	if (luaL_dofile(scriptL, gbk.data()) != LUA_OK)
	{
		auto err = lua_tostring(scriptL, -1);
		GBKToUTF16(err, &utf16);
		wchar_t title[MAX_PATH];
		swprintf_s(title, L"%sű", wbuff);
		MessageBox(hwnd, utf16.data(), title, MB_ICONWARNING);
		lua_pop(scriptL, 1);
	}
	ReloadLanguage();
}

void MyMapLayer::UpdatePxmArr(int pxaArr_w)
{
	pxmArr_w = 0;
	pxmArr_h = 0;
	for (auto& p : step_pxm)
	{
		auto x = LOWORD(p.first);
		auto y = HIWORD(p.first);
		if (x > pxmArr_w)
			pxmArr_w = x;
		if (y > pxmArr_h)
			pxmArr_h = y;
	}
	//ǿ+1
	pxmArr_w++;
	pxmArr_h++;
	pxmArr.resize(pxmArr_w * pxmArr_h);
	std::fill(pxmArr.begin(), pxmArr.end(), 0);
	//ݿ
	for (auto& p : step_pxm)
	{
		auto x = LOWORD(p.first);
		auto y = HIWORD(p.first);
		auto pxaX = LOWORD(p.second);
		auto pxaY = HIWORD(p.second);
		pxmArr[y * pxmArr_w + x] = pxaY * pxaArr_w + pxaX;
	}
}

bool MyMapLayer::operator<(const MyMapLayer& r) const
{
	return order > r.order;
}
