#pragma pack_matrix( row_major )
/*-----------------ȫֶ--------------------*/
struct VSOutput
{
    float4 pos : SV_POSITION;
    float4 color : COLOR;
    float2 tex : TEXCOORD;
};
cbuffer CBuff : register(b0)
{
	matrix mvp;
	float window_w;
	float window_h;
	float scale;
	float offX;
	float offY;
	float texture_w;
	float texture_h;
	float zBuffer;
	float HSV_h;
	float HSV_s;
	float HSV_v;
	float daylight;
}
cbuffer CBuff2 : register(b1)
{
	float cutoff;
}
/*-----------------ɫ--------------------*/
#ifdef VERTEXSHADER
struct VSInput
{
	float3 pos : POSITION;
	float4 color : COLOR;
	float2 tex : TEXCOORD;
};

VSOutput VSMain(VSInput input)
{
	VSOutput vsOut;
	vsOut.pos = mul(float4(input.pos, 1.0f), mvp);
	vsOut.color = input.color;
	vsOut.tex = input.tex;
	return vsOut;
}
#endif

/*----------------------ɫ-------------------------*/
#ifdef PIXELSHADER
Texture2D tex : register(t0);
SamplerState splr : register(s0);

float4 PSMain(VSOutput vsOut) : SV_TARGET
{
	float verticalPos = vsOut.tex.y;
	if (verticalPos > cutoff)
		return float4(0, 0, 0, 0);

	float4 color = tex.Sample(splr, vsOut.tex) * vsOut.color;
	clip(color.a == 0 ? -1 : 1);//ͼλȫ͸
	return color;
}
#endif
