#pragma pack_matrix( row_major )
/*-----------------ȫֶ--------------------*/
struct VSOutput
{
	float4 pos : SV_POSITION;
	float4 color : COLOR;
};
/*-----------------ɫ--------------------*/
#ifdef VERTEXSHADER
cbuffer CBuff : register(b0)
{
	matrix mvp;
	float window_w;
	float window_h;
	float scale;
	float offX;
	float offY;
	float texture_w;
	float texture_h;
	float zBuffer;
	float HSV_h;
	float HSV_s;
	float HSV_v;
	float daylight;
}

VSOutput VSMain(float3 pos : POSITION, float4 color : COLOR)
{
	VSOutput vsOut;
	vsOut.pos = mul(float4(floor(pos), 1.0f), mvp);
	vsOut.color = color;
	return vsOut;
}
#endif

/*----------------------ɫ-------------------------*/
#ifdef PIXELSHADER
float4 PSMain(VSOutput vsOut) : SV_TARGET
{
	return vsOut.color;
}
#endif
