#include "CWallAdjust.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CWallAdjust, CDialog)

BEGIN_MESSAGE_MAP(CWallAdjust, CDialog)
	ON_BN_CLICKED(IDOK, &CWallAdjust::OnBnClickedOk)
END_MESSAGE_MAP()

CWallAdjust::CWallAdjust(CWnd* pParent)
	: CDialog(IDD_CMAPEDITOR_WALLADJUST, pParent)
{
}

CWallAdjust::~CWallAdjust()
{
}

void CWallAdjust::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_W, edit_w);
	DDX_Control(pDX, IDC_EDIT_H, edit_h);
	DDX_Control(pDX, IDC_RADIO_CURRENT, check_current);
	DDX_Control(pDX, IDC_RADIO_ALL, check_all);
	DDX_Control(pDX, IDC_EDIT_DX, edit_dx);
	DDX_Control(pDX, IDC_EDIT_DY, edit_dy);
}

BOOL CWallAdjust::OnInitDialog()
{
	CDialog::OnInitDialog();
	check_current.SetCheck(true);
	CString str;
	str.Format(L"%d", inW);
	edit_w.SetWindowTextW(str.GetString());
	str.Format(L"%d", inH);
	edit_h.SetWindowTextW(str.GetString());
	edit_dx.SetWindowTextW(L"0");
	edit_dy.SetWindowTextW(L"0");
	return 0;
}


void CWallAdjust::OnBnClickedOk()
{
	if (check_current.GetCheck())
		outOp = 0;
	else if (check_all.GetCheck())
		outOp = 1;
	CString str;
	edit_dx.GetWindowTextW(str);
	if (str.GetLength() == 0)
	{
		MessageBoxW(L"дxƫ");
		return;
	}
	edit_dy.GetWindowTextW(str);
	if (str.GetLength() == 0)
	{
		MessageBoxW(L"дyƫ");
		return;
	}
	outDx = GetDlgItemInt(IDC_EDIT_DX);
	outDy = GetDlgItemInt(IDC_EDIT_DY);
	CDialog::OnOK();
}
