#include "CPidEditorLang.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CPidEditorLang, CDialog)

BEGIN_MESSAGE_MAP(CPidEditorLang, CDialog)
	ON_BN_CLICKED(IDOK, &CPidEditorLang::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, &CPidEditorLang::OnRefresh)
END_MESSAGE_MAP()

CPidEditorLang::CPidEditorLang(CWnd* pParent)
	: CDialog(IDD_CPIDEDITOR_LANG, pParent)
{
}

CPidEditorLang::~CPidEditorLang()
{
}

void CPidEditorLang::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_LANG, combo_lang);
}

BOOL CPidEditorLang::OnInitDialog()
{
	CDialog::OnInitDialog();
	OnRefresh();
	if (languageSel.GetLength())
	{
		//ѡָ
		auto index = combo_lang.FindString(0, languageSel.GetString());
		combo_lang.SetCurSel(index);
	}
	else
	{
		//ѡĬ
		auto index = combo_lang.FindString(0, L"Ĭ");
		combo_lang.SetCurSel(index);
	}
	return 0;
}

void CPidEditorLang::OnBnClickedOk()
{
	combo_lang.GetCurSel();
	combo_lang.GetWindowTextW(languageSel);
	EndDialog(IDOK);
}


void CPidEditorLang::OnRefresh()
{
	combo_lang.ResetContent();
	combo_lang.AddString(L"Ĭ");
	//languageĿ¼еļ
	CFileFind finder;
	bool rs = finder.FindFile(L"./data/language/*");
	while (rs)
	{
		rs = finder.FindNextFile();
		if (finder.GetFileName() == L"." ||
			finder.GetFileName() == L"..")
			continue;
		combo_lang.AddString(finder.GetFileName());
	}
}
