#include "CNewOS.h"
#include "resource.h"
#include "CMainEditor.h"
IMPLEMENT_DYNAMIC(CNewOS, CDialog)

BEGIN_MESSAGE_MAP(CNewOS, CDialog)
	ON_BN_CLICKED(IDOK, &CNewOS::OnBnClickedOk)
	ON_BN_CLICKED(IDC_DIR, &CNewOS::OnBnClickedDir)
END_MESSAGE_MAP()

CNewOS::CNewOS(CWnd* pParent)
	: CDialog(IDD_CMAINEDITOR_NEWOS, pParent)
{
}

CNewOS::~CNewOS()
{
}

void CNewOS::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_NAME, edit_label);
	DDX_Control(pDX, IDC_EDIT_AUTHOR, edit_author);
	DDX_Control(pDX, IDC_EDIT_DIR, edit_dir);
	DDX_Control(pDX, IDC_DIR, button_dir);
}

BOOL CNewOS::OnInitDialog()
{
	CDialog::OnInitDialog();
	//ÿؼʼ״̬
	if (load)//ڱ༭ģʽ
	{
		CMainEditor* mainEditor = (CMainEditor*)pMainEditor;
		edit_label.SetWindowTextW(mainEditor->osName.GetString());
		edit_author.SetWindowTextW(mainEditor->osAuthor.GetString());
		edit_dir.SetWindowTextW(mainEditor->osFilePath.GetString());
		edit_dir.EnableWindow(false);
		button_dir.EnableWindow(false);
		SetWindowText(L"༭ֿϢ");
	}
	return 0;
}


void CNewOS::OnBnClickedOk()
{
	
	//1.ǷΪ
	CStringW wstr;
	edit_label.GetWindowTextW(wstr);
	if (wstr.GetLength() == 0)
	{
		MessageBoxW(L"ֲΪ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	//2.鱣Ŀ¼ǷЧ
	edit_dir.GetWindowTextW(wstr);
	if (wstr.GetLength() == 0)
	{
		MessageBoxW(L"ѡһĿ¼", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	wchar_t buff[MAX_PATH];
	ZeroMemory(&buff, sizeof(buff));
	//ȥļĿ¼Ƿ
	int len = wstr.ReverseFind('\\') + 1;
	CString cutStr = wstr.Left(len);
	wcscpy_s(buff, cutStr.GetString());
	if (!PathIsDirectoryW(buff))
	{
		MessageBoxW(L"Ŀ¼", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	//
	edit_label.GetWindowTextW(outName);
	edit_author.GetWindowTextW(outAuthor);
	edit_dir.GetWindowTextW(outFilePath);
	CDialog::OnOK();
}


void CNewOS::OnBnClickedDir()
{
	
	CFileDialog fd(false, TEXT(""), TEXT("ocstore.db"), OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT, TEXT("ݿļ(*.db)|*.db|ļ(*.*)|*.*||"), this);
	if (fd.DoModal() != IDOK)
		return;
	edit_dir.SetWindowText(fd.GetPathName());
}
