#include "CNewMC.h"
#include "resource.h"
#include "CMainEditor.h"
#include "COSLabel.h"

IMPLEMENT_DYNAMIC(CNewMC, CDialog)

BEGIN_MESSAGE_MAP(CNewMC, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_DIR, &CNewMC::OnBnClickedButtonDir)
	ON_BN_CLICKED(IDOK, &CNewMC::OnBnClickedOk)
	ON_COMMAND(ID_ADD_LABEL, &CNewMC::OnAddLabel)
	ON_COMMAND(ID_RENAME_LABEL, &CNewMC::OnRenameLabel)
	ON_COMMAND(ID_DELETE_LABEL, &CNewMC::OnDeleteLabel)
END_MESSAGE_MAP()

CNewMC::CNewMC(CWnd* pParent)
	: CDialog(IDD_CMCEDITOR_NEWMC, pParent)
{
}

CNewMC::~CNewMC()
{
}

void CNewMC::UpdateContext()
{
	auto mainEditor = (CMainEditor*)pMainEditor;
	listbox_set.ResetContent();
	for (auto& p : labelMap)
		listbox_set.AddString(p.second.name.GetString());
}

void CNewMC::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BUTTON_DIR, button_dir);
	static_face = (CStatic*)GetDlgItem(IDC_STATIC_FACE);
	DDX_Control(pDX, IDC_RADIO_CREATURE, radio_creature);
	DDX_Control(pDX, IDC_RADIO_SPRITE, radio_sprite);
	DDX_Control(pDX, IDC_EDIT_IMAGE, edit_image);
	DDX_Control(pDX, IDC_EDIT_NAME, edit_label);
	DDX_Control(pDX, IDC_COMBO_POS, combobox_pos);
	DDX_Control(pDX, IDC_COMBO_CHAR, combobox_char);
	DDX_Control(pDX, IDC_RADIO_FEMALE, radio_female);
	DDX_Control(pDX, IDC_RADIO_MALE, radio_male);
	DDX_Control(pDX, IDC_RADIO_NONE, radio_none);
	DDX_Control(pDX, IDC_EDIT_IDEAL, edit_ideal);
	static_set = (CStatic*)GetDlgItem(IDC_STATIC_SET);
	DDX_Control(pDX, IDC_LIST_SET, listbox_set);
}

BOOL CNewMC::OnInitDialog()
{
	CDialog::OnInitDialog();
	auto mainEditor = (CMainEditor*)pMainEditor;
	//Ӵ
	picbox.Create(IDD_CMYPICBOX, this);
	CRect rc;
	static_face->GetWindowRect(&rc);
	ScreenToClient(&rc);
	static_face->EnableWindow(false);
	static_face->ShowWindow(SW_HIDE);
	picbox.MoveWindow(&rc);
	picbox.ShowWindow(SW_SHOW);
	//ʼؼ
	radio_creature.SetCheck(true);//ĬϹѡ
	radio_none.SetCheck(true);//ԱĬϹѡ
	//ʼϿ
	std::vector<CString> strList;
	mainEditor->GetDBField_List(&strList, DBTABLENAME_MYCHAR_POSITION, L"mcpos");
	for (auto& p : strList)
		combobox_pos.AddString(p);
	mainEditor->GetDBField_List(&strList, DBTABLENAME_MYCHAR_CHARACTER, L"mcchar");
	for (auto& p : strList)
		combobox_char.AddString(p);
	listbox_set.SetMenu(IDR_CMCPREP_RMENU, IDR_CMCPREP_RMENU_NOSEL);
	//Ǳ༭ģʽ
	if (load)
	{
		SetWindowTextW(L"༭");
		auto& mc = outMC;
		picbox.SetPic(mc.facePng);//ͷ
		if (mc.lifeType == 0)
			radio_creature.SetCheck(true);
		else if (mc.lifeType == 1)
			radio_sprite.SetCheck(true);
		edit_image.SetWindowTextW(mc.image);//ӡ
		edit_label.SetWindowTextW(mc.name);//
		combobox_pos.SetCurSel(combobox_pos.FindString(0, mc.mcpos.GetString()));//ɫλ
		combobox_char.SetCurSel(combobox_char.FindString(0, mc.mcChar.GetString()));;//ɫԸ
		if (mc.gender == 0)
			radio_none.SetCheck(true);
		else if (mc.gender == 1)
			radio_female.SetCheck(true);
		else if (mc.gender == 2)
			radio_male.SetCheck(true);
		edit_ideal.SetWindowTextW(mc.ideal); //
		mainEditor->GetXMLLabel_Map(&labelMap, mc.labelXML);//趨ʵֱ
		UpdateContext();
	}
	return 0;
}


void CNewMC::OnBnClickedButtonDir()
{
	
	CFileDialog fd(true, TEXT(""), TEXT(""), OFN_FILEMUSTEXIST, TEXT("PNGͼļ(*.png)|*.png|BMPͼļ(*.bmp)|*.bmp|JPEGͼļ(*.jpg)|*.jpg|ļ(*.*)|*.*||"), this);
	if (fd.DoModal() != IDOK)
		return;
	auto mainEditor = (CMainEditor*)pMainEditor;
	outMC.facePng = fd.GetPathName();
	picbox.SetPic(outMC.facePng);
}

void CNewMC::OnBnClickedOk()
{
	
	//ȷϸǷд
	auto mainEditor = (CMainEditor*)pMainEditor;
	//Ƿѡ
	if (radio_creature.GetCheck() == false && 
		radio_sprite.GetCheck() == false)
	{
		MessageBoxW(L"ѡһ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	//Ƿд
	CString name;
	edit_label.GetWindowTextW(name);
	if (name.GetLength() == 0)
	{
		MessageBoxW(L"д", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	//ɫλ
	CString mcpos;
	combobox_pos.GetWindowTextW(mcpos);
	if (mcpos.GetLength() == 0)
	{
		MessageBoxW(L"ѡһɫλ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	//ɫԸ
	CString mcchar;
	combobox_char.GetWindowTextW(mcchar);
	if (mcchar.GetLength() == 0)
	{
		MessageBoxW(L"ѡһɫԸ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	//ǷѡԱ
	if (radio_female.GetCheck() == false && 
		radio_male.GetCheck() == false &&
		radio_none.GetCheck() == false)
	{
		MessageBoxW(L"ѡһԱ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	//дֵ
	if (radio_creature.GetCheck())
		outMC.lifeType = 0;
	else if (radio_sprite.GetCheck())
		outMC.lifeType = 1;
	edit_image.GetWindowTextW(outMC.image);
	outMC.name = name;
	outMC.mcpos = mcpos;
	outMC.mcChar = mcchar;
	if (radio_none.GetCheck())
		outMC.gender = 0;
	else if (radio_female.GetCheck())
		outMC.gender = 1;
	else if (radio_male.GetCheck())
		outMC.gender = 2;
	edit_ideal.GetWindowTextW(outMC.ideal);
	outMC.labelXML = mainEditor->GetXMLString(labelMap);
	CDialog::OnOK();
}


void CNewMC::OnAddLabel()
{
	
	COSLabel dlg;
	dlg.SetWindowTitleAndLabel(L"趨ʵֱǩ", L"趨");
	if (dlg.DoModal() != IDOK)
		return;
	MyLabelXML label;
	label.name = dlg.outLabel.GetString();
	if (labelMap.find(label.name.GetString()) != labelMap.end())
	{
		CString str;
		str.Format(L"ʧ\nͬ趨%s", label.name.GetString());
		MessageBoxW(str.GetString(), L"ʧ", MB_ICONINFORMATION);
		return;
	}
	labelMap.insert(std::make_pair(label.name.GetString(), label));
	UpdateContext();
}


void CNewMC::OnRenameLabel()
{
	
	int sel = listbox_set.GetCurSel();
	CString name_prep;
	listbox_set.GetText(sel, name_prep);
	COSLabel dlg;
	dlg.load = true;
	dlg.outLabel = name_prep;
	dlg.SetWindowTitleAndLabel(L"ǩ", L"趨");
	if (dlg.DoModal() != IDOK)
		return;
	if (dlg.outLabel == name_prep)
		return;
	MyLabelXML label = labelMap.at(name_prep.GetString());
	label.name = dlg.outLabel;
	labelMap.erase(name_prep.GetString());
	if (labelMap.find(label.name.GetString()) != labelMap.end())
	{
		CString str;
		str.Format(L"ʧ\nͬ趨%s", label.name.GetString());
		MessageBoxW(str.GetString(), L"ʧ", MB_ICONINFORMATION);
		return;
	}
	labelMap.insert(std::make_pair(label.name.GetString(), label));
	UpdateContext();
}


void CNewMC::OnDeleteLabel()
{
	
	int sel = listbox_set.GetCurSel();
	CString name;
	listbox_set.GetText(sel, name);
	labelMap.erase(name.GetString());
	UpdateContext();
}
