#include "CMoveMap.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CMoveMap, CDialog)

BEGIN_MESSAGE_MAP(CMoveMap, CDialog)
	ON_BN_CLICKED(IDOK, &CMoveMap::OnBnClickedOk)
END_MESSAGE_MAP()

CMoveMap::CMoveMap(CWnd* pParent)
	: CDialog(IDD_CMAPEDITOR_MOVEMAP, pParent)
{
}

CMoveMap::~CMoveMap()
{
}

void CMoveMap::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_X, edit_x);
	DDX_Control(pDX, IDC_EDIT_Y, edit_y);
	DDX_Control(pDX, IDC_CHECK_LOOP, check_loop);
	DDX_Control(pDX, IDC_CHECK_MOVE_LOOPLAYER, check_moveLoopLayer);
}

BOOL CMoveMap::OnInitDialog()
{
	CDialog::OnInitDialog();
	edit_x.SetWindowTextW(L"0");
	edit_y.SetWindowTextW(L"0");
	check_loop.SetCheck(true);
	return 0;
}


void CMoveMap::OnBnClickedOk()
{
	CString strX, strY;
	edit_x.GetWindowTextW(strX);
	edit_x.GetWindowTextW(strY);
	if (strX.GetLength() == 0)
	{
		MessageBoxW(L"δдX");
		return;
	}
	if (strY.GetLength() == 0)
	{
		MessageBoxW(L"δдY");
		return;
	}
	outX = GetDlgItemInt(IDC_EDIT_X);
	outY = GetDlgItemInt(IDC_EDIT_Y);
	outLoop = check_loop.GetCheck() != 0;
	outMoveLoopLayer = check_moveLoopLayer.GetCheck() != 0;
	CDialog::OnOK();
}
