#include "CMCCharTable.h"
#include "resource.h"
#include "CMainEditor.h"
#include "COSLabel.h"
#include "CMCEditor.h"

IMPLEMENT_DYNAMIC(CMCCharTable, CDialog)

BEGIN_MESSAGE_MAP(CMCCharTable, CDialog)
	ON_COMMAND(IDOK, &CMCCharTable::OnEnterKey)
	ON_WM_SIZE()
	ON_COMMAND(ID_ADD_LABEL, &CMCCharTable::OnAddLabel)
	ON_COMMAND(ID_RENAME_LABEL, &CMCCharTable::OnRenameLabel)
	ON_COMMAND(ID_DELETE_LABEL, &CMCCharTable::OnDeleteLabel)
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()

CMCCharTable::CMCCharTable(CWnd* pParent)
	: CDialog(IDD_CMCCHAR_TABLE, pParent)
{
}

CMCCharTable::~CMCCharTable()
{
}

void CMCCharTable::UpdateContext()
{
	list_mcchar.ResetContent();
	auto mainEditor = (CMainEditor*)pMainEditor;
	std::vector<CString> labelList;
	mainEditor->GetDBField_List(&labelList, DBTABLENAME_MYCHAR_CHARACTER, L"mcchar");
	for (auto& p : labelList)
		list_mcchar.AddString(p);
}

void CMCCharTable::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	groupbox_mcchar = (CStatic*)GetDlgItem(IDC_STATIC_MCCHAR);
	DDX_Control(pDX, IDC_LIST_MCCHAR, list_mcchar);
	groupbox_same = (CStatic*)GetDlgItem(IDC_STATIC_MCCHAR_SAME);
	DDX_Control(pDX, IDC_LIST_MCCHAR_SAME, list_same);
}

BOOL CMCCharTable::OnInitDialog()
{
	CDialog::OnInitDialog();
	//Ӧóͼ
	auto hIcon = AfxGetApp()->LoadIcon(IDI_APPICON_TABLE);
	SetIcon(hIcon, true);
	//ÿؼ
	list_mcchar.SetMenu(IDR_CMCPREP_RMENU, IDR_CMCPREP_RMENU_NOSEL);
	return 0;
}

void CMCCharTable::OnCancel()
{
	ShowWindow(SW_HIDE);
}

void CMCCharTable::OnEnterKey()
{
}

void CMCCharTable::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	
	if (!groupbox_mcchar)
		return;
	int dx = 20;
	int dy = 20;
	int c = 36;
	groupbox_mcchar->MoveWindow(dx, dy, cx / 2 - dx - dx / 2, cy - dy * 2);
	list_mcchar.MoveWindow(dx, dy + c, cx / 2 - dx - dx / 2, cy - dy * 2 - c);
	groupbox_same->MoveWindow(dx / 2 + cx / 2, dy, cx / 2 - dx - dx / 2, cy - dy * 2);
	list_same.MoveWindow(dx / 2 + cx / 2, dy + c, cx / 2 - dx - dx / 2, cy - dy * 2 - c);

}

void CMCCharTable::OnAddLabel()
{
	
	//ӱǩ
	COSLabel dlg;
	dlg.SetWindowTitleAndLabel(L"ӽɫԸǩ", L"ǩ");
	if (dlg.DoModal() != IDOK)
		return;
	//ݿӱǩ
	auto mainEditor = (CMainEditor*)pMainEditor;
	mainEditor->SetDBField(DBTABLENAME_MYCHAR_CHARACTER, L"mcchar", L"", dlg.outLabel);
	UpdateContext();
}


void CMCCharTable::OnRenameLabel()
{
	
	//ǩ
	int index = list_mcchar.GetCurSel();
	CString mccharStr;
	list_mcchar.GetText(index, mccharStr);

	COSLabel dlg;
	dlg.outLabel = mccharStr;
	dlg.load = true;
	dlg.SetWindowTitleAndLabel(L"ɫԸǩ", L"ǩ");
	if (dlg.DoModal() != IDOK)
		return;
	if (mccharStr == dlg.outLabel)
		return;
	//±ǩ
	auto mainEditor = (CMainEditor*)pMainEditor;
	mainEditor->SetDBField(DBTABLENAME_MYCHAR_CHARACTER, L"mcchar", mccharStr, dlg.outLabel);
	UpdateContext();
}


void CMCCharTable::OnDeleteLabel()
{
	
	//ɾǩ
	int index = list_mcchar.GetCurSel();
	CString mccharStr;
	list_mcchar.GetText(index, mccharStr);

	auto mainEditor = (CMainEditor*)pMainEditor;
	mainEditor->DelDBField(DBTABLENAME_MYCHAR_CHARACTER, L"mcchar", mccharStr);
	UpdateContext();
}


void CMCCharTable::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	auto parentWindow = (CMCEditor*)pParentWindow;
	if (bShow)
		parentWindow->GetMenu()->GetSubMenu(CMCEDITOR_MENUINDEX_WINDOW)->CheckMenuItem(ID_MCCHAR_TABLE, MF_BYCOMMAND | MF_CHECKED);
	else
		parentWindow->GetMenu()->GetSubMenu(CMCEDITOR_MENUINDEX_WINDOW)->CheckMenuItem(ID_MCCHAR_TABLE, MF_BYCOMMAND | MF_UNCHECKED);
}
