#include "CImportCaveStoryPxm.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CImportCaveStoryPxm, CDialog)

BEGIN_MESSAGE_MAP(CImportCaveStoryPxm, CDialog)
	ON_BN_CLICKED(IDOK, &CImportCaveStoryPxm::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE, &CImportCaveStoryPxm::OnBnClickedButtonBrowse)
END_MESSAGE_MAP()

CImportCaveStoryPxm::CImportCaveStoryPxm(CWnd* pParent)
	: CDialog(IDD_CIMPORT_CAVESTORY_PXM, pParent)
{
}

CImportCaveStoryPxm::~CImportCaveStoryPxm()
{
}

void CImportCaveStoryPxm::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_BROWSE, edit_browse);
	DDX_Control(pDX, IDC_BUTTON_BROWSE, button_browse);
	DDX_Control(pDX, IDC_EDIT_OFFX, edit_offx);
	DDX_Control(pDX, IDC_EDIT_OFFY, edit_offy);
}

BOOL CImportCaveStoryPxm::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetDlgItemInt(IDC_EDIT_OFFX, inLastOffX);
	SetDlgItemInt(IDC_EDIT_OFFY, inLastOffY);
	return 0;
}


void CImportCaveStoryPxm::OnBnClickedOk()
{
	// TODO: ڴӿؼ֪ͨ
	//ƫX
	int offX = 0;
	CString strOffX;
	edit_offx.GetWindowTextW(strOffX);
	if (strOffX.GetLength() == 0)
	{
		MessageBoxW(L"д뵽ĿƫֵX", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	offX = GetDlgItemInt(IDC_EDIT_OFFX);
	//ƫY
	int offY = 0;
	CString strOffY;
	edit_offy.GetWindowTextW(strOffY);
	if (strOffY.GetLength() == 0)
	{
		MessageBoxW(L"д뵽ĿƫֵY", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	offY = GetDlgItemInt(IDC_EDIT_OFFY);
	//Ŀ¼Ƿд
	CString pxmfile;
	edit_browse.GetWindowTextW(pxmfile);
	if (pxmfile.GetLength() == 0)
	{
		MessageBoxW(L"дļĿ¼", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	//ȡļ
	//ȷļǷ
	FILE* fp = nullptr;
	_wfopen_s(&fp, pxmfile.GetString(), L"rb");
	if (!fp)
	{
		CString err;
		err.Format(L"޷ȡļ%s", pxmfile.GetString());
		MessageBoxW(err.GetString(), L"ļȡ", MB_ICONINFORMATION);
		return;
	}
	//ļͷϢ
	char headinfo[4];
	fread_s(headinfo, sizeof(headinfo), 4, 1, fp);
	if (!(headinfo[0] == 0x50 &&
		headinfo[1] == 0x58 &&
		headinfo[2] == 0x4D &&
		headinfo[3] == 0x10))
	{
		CString err;
		err.Format(L"%s\nһͼļ", pxmfile.GetString());
		MessageBoxW(err.GetString(), L"ļͷϢУʧ", MB_ICONINFORMATION);
		return;
	}
	//ȡͼݴС
	fseek(fp, 0, SEEK_END);
	size_t fileLen = ftell(fp);
	fseek(fp, 4, SEEK_SET);
	//ȡͼߴϢ
	UINT16 map_w, map_h;
	fread(&map_w, sizeof(UINT16), 1, fp);
	fread(&map_h, sizeof(UINT16), 1, fp);
	size_t mapDataSize = fileLen - 8;
	mapData.resize(mapDataSize);
	fread(mapData.data(), mapDataSize, 1, fp);
	//תΪͼ
	outPxm.clear();
	for (int y = 0; y < map_h; y++)
	{
		for (int x = 0; x < map_w; x++)
		{
			int pxaY = mapData[y * map_w + x] / 16 + offY;
			int pxaX = mapData[y * map_w + x] % 16 + offX;
			outPxm[MAKELONG( x,  y)] = MAKELONG(pxaX, pxaY);
		}
	}
	outPxm_w = map_w;
	outPxm_h = map_h;
	inLastOffX = offX;
	inLastOffY = offY;
	CDialog::OnOK();
}


void CImportCaveStoryPxm::OnBnClickedButtonBrowse()
{
	//pxmļ
	CFileDialog fd(TRUE, TEXT(""), TEXT(""), OFN_FILEMUSTEXIST | OFN_HIDEREADONLY, TEXT("ͼļ(*.pxm)|*.pxm|ļ(*.*)|*.*||"), this);
	if (fd.DoModal() != IDOK)
		return;
	CString str = fd.GetPathName();
	edit_browse.SetWindowTextW(str.GetString());
}
