#include "CAniEditorLayerEdit.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CAniEditorLayerEdit, CDialog)

BEGIN_MESSAGE_MAP(CAniEditorLayerEdit, CDialog)
	ON_BN_CLICKED(IDOK, &CAniEditorLayerEdit::OnBnClickedOk)
	ON_BN_CLICKED(IDC_RADIO_INSERT_U, &CAniEditorLayerEdit::OnBnClickedRadioInsert)
	ON_BN_CLICKED(IDC_RADIO_INSERT_D, &CAniEditorLayerEdit::OnBnClickedRadioInsert)
	ON_BN_CLICKED(IDC_RADIO_SWAP_LAYER, &CAniEditorLayerEdit::OnBnClickedRadioSwapLayer)
	ON_BN_CLICKED(IDC_RADIO_COPY_LAYER, &CAniEditorLayerEdit::OnBnClickedRadioSwapLayer)
	ON_BN_CLICKED(IDC_RADIO_DELETE_LAYER, &CAniEditorLayerEdit::OnBnClickedRadioDeleteLayer)
END_MESSAGE_MAP()

CAniEditorLayerEdit::CAniEditorLayerEdit(CWnd* pParent)
	: CDialog(IDD_CANIEDITOR_LAYEREDIT, pParent)
{
}

CAniEditorLayerEdit::~CAniEditorLayerEdit()
{
}

void CAniEditorLayerEdit::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_SRC_LAYER, edit_srcLayer);
	DDX_Control(pDX, IDC_EDIT_DST_LAYER, edit_dstLayer);
	DDX_Control(pDX, IDC_EDIT_INSERT_NUM, edit_num);
	DDX_Control(pDX, IDC_RADIO_INSERT_U, radio_insert_up);
	DDX_Control(pDX, IDC_RADIO_INSERT_D, radio_insert_down);
	DDX_Control(pDX, IDC_RADIO_SWAP_LAYER, radio_swap);
	DDX_Control(pDX, IDC_RADIO_COPY_LAYER, radio_copy);
	DDX_Control(pDX, IDC_RADIO_DELETE_LAYER, radio_delete);
}

BOOL CAniEditorLayerEdit::OnInitDialog()
{
	CDialog::OnInitDialog();
	//дؼ
	SetDlgItemInt(IDC_EDIT_SRC_LAYER, outSrcLayerNum);
	SetDlgItemInt(IDC_EDIT_INSERT_NUM, outNum);
	switch (outOp)
	{
	case 0:
		radio_insert_up.SetCheck(true);
		edit_num.EnableWindow(true);
		edit_dstLayer.EnableWindow(false);
		break;
	case 1:
		radio_insert_down.SetCheck(true);
		edit_num.EnableWindow(true);
		edit_dstLayer.EnableWindow(false);
		break;
	case 2:
		radio_swap.SetCheck(true);
		edit_num.EnableWindow(false);
		edit_dstLayer.EnableWindow(true);
		break;
	case 3:
		radio_copy.SetCheck(true);
		edit_num.EnableWindow(false);
		edit_dstLayer.EnableWindow(true);
		break;
	case 4:
		radio_delete.SetCheck(true);
		edit_num.EnableWindow(false);
		edit_dstLayer.EnableWindow(false);
		break;
	}
	return 0;
}


void CAniEditorLayerEdit::OnBnClickedOk()
{
	CString strSrcLayer;
	CString strDstLayer;
	CString strNum;
	edit_srcLayer.GetWindowTextW(strSrcLayer);
	if (strSrcLayer.GetLength() == 0)
	{
		MessageBox(L"δдǰѡеͼš");
		return;
	}
	if (radio_insert_up.GetCheck())
		outOp = 0;
	else if (radio_insert_down.GetCheck())
		outOp = 1;
	else if (radio_swap.GetCheck())
		outOp = 2;
	else if (radio_copy.GetCheck())
		outOp = 3;
	else if (radio_delete.GetCheck())
		outOp = 4;
	switch (outOp)
	{
	case 0:
	case 1:
		edit_num.GetWindowTextW(strNum);
		if (strNum.GetLength() == 0)
		{
			MessageBox(L"δд");
			return;
		}
		break;
	case 2:
	case 3:
		edit_dstLayer.GetWindowTextW(strDstLayer);
		if (strDstLayer.GetLength() == 0)
		{
			MessageBox(L"δдĿͼš");
			return;
		}
		break;
	}
	outSrcLayerNum = GetDlgItemInt(IDC_EDIT_SRC_LAYER);
	CString outOfRange;
	outOfRange.Format(L"ͼųΧ[0-%d]", testLayerNum - 1);
	if (outSrcLayerNum >= testLayerNum)
	{
		MessageBox(L"Чġǰѡеͼš", outOfRange.GetString());
		return;
	}
	outDstLayerNum = GetDlgItemInt(IDC_EDIT_DST_LAYER);
	if (outDstLayerNum >= testLayerNum)
	{
		MessageBox(L"ЧġĿͼš", outOfRange.GetString());
		return;
	}
	outNum = GetDlgItemInt(IDC_EDIT_INSERT_NUM);
	CDialog::OnOK();
}


void CAniEditorLayerEdit::OnBnClickedRadioInsert()
{
	edit_num.EnableWindow(true);
	edit_dstLayer.EnableWindow(false);
}


void CAniEditorLayerEdit::OnBnClickedRadioSwapLayer()
{
	edit_num.EnableWindow(false);
	edit_dstLayer.EnableWindow(true);
}


void CAniEditorLayerEdit::OnBnClickedRadioDeleteLayer()
{
	edit_num.EnableWindow(false);
	edit_dstLayer.EnableWindow(false);
}
