#include "global.h"
#include "Entity.h"
#include <sstream>
#include <random>
const float deg2rad = 3.141592654f / 180.0f;
void MyRGBA::Set(DWORD c)
{
	r = c & 0xff;
	g = (c >> 8) & 0xff;
	b = (c >> 16) & 0xff;
	a = (c >> 24) & 0xff;
}

DWORD MyRGBA::Get()
{
	return RGBA(r, g, b, a);
}

static const bool PxaIsEmptyTable[] =
{
	true ,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,true ,
	true ,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,true ,
	true ,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,true ,
	true ,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,true ,
	true ,true ,true ,false,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,
	true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,
	true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,
	true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,
};

bool PxaIsEmpty(int pxaID)
{
	return PxaIsEmptyTable[pxaID];
}

static const bool PxaIsIceTable[] =
{
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,false,
	false,false,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
};

bool PxaIsIce(int pxaID)
{
	return PxaIsIceTable[pxaID];
}

static const bool PxaIsBlock_Player_Table[] =
{
	false,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,
	true ,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,
	true ,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
};

static const bool PxaIsBlock_NoPlayer_Table[] =
{
	false,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,true ,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
};

bool PxaIsBlock(int pxaID, bool isPlayer)
{
	if (isPlayer)
		return PxaIsBlock_Player_Table[pxaID];
	else 
		return PxaIsBlock_NoPlayer_Table[pxaID];
}

static const bool PxaIsWaterTable[] =
{
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,true ,false,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	true ,false,false,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,true ,
	true,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,true ,true ,false,false,false,false,false,false,false,false,false,false,false,false,false,
	false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,
	true ,true ,true ,true ,true ,true ,true ,true ,false,false,false,false,false,false,false,false,
};

bool PxaIsWater(int pxaID)
{
	return PxaIsWaterTable[pxaID];
}

int Random(int min, int max)
{
	const int range = max - min + 1;
	return min + rand() % range;
}

bool ParseInts(const wchar_t* str, std::vector<int>& outArr)
{
	std::wstringstream ss(str);
	std::wstring item;
	wchar_t delimiter = L',';

	outArr.clear();
	while (std::getline(ss, item, delimiter))
	{
		try
		{
			outArr.push_back(std::stoi(item));
		}
		catch (const std::exception)
		{
			return false;
		}
	}
	return true;
}

void FillZeroSumVector(std::vector<XMVECTOR>& vecArr, int len)
{
	vecArr.clear();
	for (int i = 0; i < len; i++)
	{
		//
		//Ƕ
		auto radian = (float)Random(0, 360) * deg2rad;
		//
		XMVECTOR vec = XMVectorSet(cosf(radian), sinf(radian), 0, 0);
		vecArr.push_back(vec);
		//뷴
		vecArr.push_back(-vec);
	}
	//˳
	std::random_device rd;
	std::mt19937 gen(rd());
	std::shuffle(vecArr.begin(), vecArr.end(), gen);
}

float lerp(float start, float end, float t)
{
	return start + t * (end - start);
}
