#include "PeSpark.h"

PeSpark::PeSpark()
{
	type = 3;
	angle = (float)Random(0, 360);
	length = (float)Random(25, 50);
	lenstart = length;
}

void PeSpark::Step()
{
	if (length >= 1.0f)
		length /= 1.3f;
	else
		Destroy();
	r += length / 2.0f;
	SetShape();
}

void PeSpark::DeltaTime(float deltaTime)
{
	//λ
	if (lineList.size() < lineList_set_last.size())
		lineList.resize(lineList_set_last.size());
	for (int i = 0; i < lineList_set_last.size(); i++)
	{
		auto& dst = lineList[i];
		auto& src_last = lineList_set_last[i];
		auto& src = lineList_set[i];
		dst.x = lerp(src_last.x, src.x, deltaTime);
		dst.y = lerp(src_last.y, src.y, deltaTime);
		dst.c = src.c;
	}
	Entity::DeltaTime(deltaTime);
}

void PeSpark::SetShape()
{
	lineList_set_last.swap(lineList_set);
	UINT8 alpha = (UINT8)(0xff * length / lenstart);
	float x1 = r / 2 * cosf(angle * deg2rad);
	float y1 = r / 2 * sinf(angle * deg2rad);
	float x2 = (r + length) / 2 * cosf(angle * deg2rad);
	float y2 = (r + length) / 2 * sinf(angle * deg2rad);
	DWORD c = RGBA(0xff, 0xff, 0xff, alpha);
	AddLine(lineList_set, 0, x1, y1, c, x2, y2, c);
}

std::shared_ptr<Entity> CreatePeSpark()
{
	return std::make_shared<PeSpark>();
}

void SetPeSpark(std::shared_ptr<Entity> parent, float x, float y, int nMin, int nMax, float angle)
{
	int num = Random(nMin, nMax);
	for (size_t i = 0; i < num; i++)
	{
		float angle_range = (float)Random(-30, 30);
		auto e = std::make_shared<PeSpark>();
		e->x = x;
		e->y = y;
		e->angle = angle + angle_range;
		parent->gameFunc->SetEntity(parent, e);
	}
}

void SetPeSparkSmall(std::shared_ptr<Entity> parent, float x, float y, int nMin, int nMax, float angle)
{
	int num = Random(nMin, nMax);
	for (size_t i = 0; i < num; i++)
	{
		float angle_range = (float)Random(-30, 30);
		auto e = std::make_shared<PeSpark>();
		e->x = x;
		e->y = y;
		e->angle = angle + angle_range;
		e->length = (float)Random(2, 6);
		e->lenstart = e->length;
		parent->gameFunc->SetEntity(parent, e);
	}
}

