#include "CS_TapScissorsRain_Locater.h"
#include "CS_Boss_TapScissorsClone.h"
#include "CS_FallRock.h"
CS_TapScissorsRain_Locater::CS_TapScissorsRain_Locater()
{
	el.name = CS_TAPSCISSORSRAIN_LOCATER_CREATENAME;
}

void CS_TapScissorsRain_Locater::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"fallscissors")
	{
		appear_num = 1;
		appear_counter = appear_counter_max;
		delay_counter = lr;
		bSetScissors = true;
	}
	else if (stateName == L"fallrock")
	{
		appear_num = 0;
		appear_counter = appear_counter_max;
		delay_counter = lr;
		bSetScissors = false;
	}
}

void CS_TapScissorsRain_Locater::Step()
{
	if (delay_counter > 0)
	{
		delay_counter--;
		return;
	}
	if (appear_counter > 0)
	{
		appear_counter--;
		if (appear_counter == 0)
		{
			if (bSetScissors)
			{
				//ü
				SetScissors();
			}
			else
			{
				//ʯ
				SetRock();
			}
			if (appear_num > 0)
			{
				appear_num--;
				appear_counter = appear_counter_max;
			}
		}
	}
}

void CS_TapScissorsRain_Locater::SetScissors()
{
	auto am = std::make_shared<CS_Boss_TapScissorsClone>(shared_from_this());
	am->x = x;
	am->y = y - 16;
	gameFunc->SetEntity(shared_from_this(), am);
}

void CS_TapScissorsRain_Locater::SetRock()
{
	bool bLarge = Random(0, 10) % 2 == 0;
	auto am = std::make_shared<CS_FallRock>();
	am->x = x;
	am->y = y - 16;
	if (bLarge)
	{
		am->el.arg = am->ani.sprite_index = L"ls_fallrock_balcony_large";
		am->cbRect.left = am->cbRect.right = am->cbRect.top = am->cbRect.bottom = 16;
	}
	else
	{
		am->el.arg = am->ani.sprite_index = L"ls_fallrock_balcony";
	}
	gameFunc->SetEntity(shared_from_this(), am);
}

std::shared_ptr<Entity> CreateCS_TapScissorsRain_Locater()
{
	return std::make_shared<CS_TapScissorsRain_Locater>();
}
